% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_ismt.R
\name{full_ismt}
\alias{full_ismt}
\title{Cálculo de ISMT completo a partir del Censo 2017 -- Full ISMT calculation from 2017 Census.}
\usage{
full_ismt(
  df,
  r,
  ur,
  rfield = "id_region",
  urfield = "tipo_area",
  year = 2017,
  tipo_vivienda = "tipoviv",
  ocupacion = "ocup_viv",
  ndorms = "ndorms",
  parentesco = "parentesco",
  muro = "mat_muro",
  techo = "mat_techo",
  piso = "mat_piso",
  grouping = "id_zona",
  level = "zc"
)
}
\arguments{
\item{df}{objeto \code{data.frame}. Default es \code{2017}. || || \code{data.frame} object. Default is \code{2017}.}

\item{r}{integer. Se aceptan valores entre 1 y 16 para Chile 2017. Si \code{r == 99}, no se define una región en particular y se trabaja con valores a nivel nacional. || || integer. Values between 1 and 16 are acceptable for Chile 2017. If \code{r == 99}, no region will be defined and work will continue with national level values.}

\item{ur}{integer. Valores aceptables son \code{1} y \code{2}. Define si se requiere zona urbana \code{ur = 1} o rural \code{ur = 2}. || || integer. Accepted values are \code{1} and \code{2}. Defines whether urban \code{ur = 1} or rural \code{ur = 2} data is requested.}

\item{rfield}{string. Nombre del campo que corresponde al número de la región. Default es \code{region}. || || string. Name of the field corresponding to the region number. Default is \code{region}.}

\item{urfield}{string. Nombre del campo que define el tipo de área (urbana o rural). Default es \code{tipo_area}. || || string Name of the field corresponding to the desired area (urban or rural). Default is \code{tipo_area}.}

\item{year}{integer. Default es \code{2017}. || || integer. Default is \code{2017}.}

\item{tipo_vivienda}{string. Nombre del campo de tipo de vivienda. Default es \code{tipoviv}. || || string. Name of the dwelling type field. Default is \code{tipoviv}.}

\item{ocupacion}{string. Nombre del campo de ocupación de la vivienda. Default es \code{ocup_viv}. || || string. Name of the home occupation field. Default is \code{ocup_viv}.}

\item{ndorms}{string. Nombre del campo con el número de dormitorios del hogar. Default es \code{ndorms}. || || string. Name of the number of bedrooms field. Default is \code{ndorms}.}

\item{parentesco}{string. Nombre del campo de parentesco. Default es \code{parentesco}. || || string. Name of the familial relationship field. Default is \code{parentesco}.}

\item{muro}{string. Nombre del campo de condición del muro. Default es \code{mat_muro}. || || string. Name of the wall condition field. Default is \code{mat_muro}.}

\item{techo}{string. Nombre del campo de condición del techo. Default es \code{mat_techo}. || || string. Name of the ceiling condition field. Default is \code{mat_techo}.}

\item{piso}{string. Nombre del campo de condición del suelo. Default es \code{mat_piso}. || || string. Name of the floor condition field. Default is \code{mat_piso}.}

\item{grouping}{string. Nombre del campo con la variable de la unidad espacial agrupadora. Default es \code{id_zona}. || || string. Name of the field with the spacial grouping unit variable. Default is \code{id_zona}.}

\item{level}{\code{string}. Nivel de agrupación de los datos finales. Acepta valores \code{zc} (zona censal) y \code{mzn} (manzana). El nivel de manzana no está disponible para el 2017 debido al secreto estadístico de la base de datos de origen. Default es \code{zc}. || || \code{string}. Grouping level for the final data. Values \code{zc} (census zone) and \code{mzn} (block). Block level is not available for 2017 due to statistical secret of original database. Default is \code{zc}.}
}
\value{
objeto data.frame conteniendo el cálculo completo del ISMT.
}
\description{
Ejecuta el cálculo completo del ISMT. Agrupa las funciones `literalize()`, `geofilter()`, `cleanup()`, `precalc()`, `get_pca()` e `ismt_scores()`. La tabla obtenida debería ser idéntica al resultado de concatenar estas funciones una a una.
}
\examples{
 \donttest{
   data(c17_example)
   ismt <- full_ismt(c17_example, 10, 1)
 }
}
