% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ismt_scores.R
\name{ismt_scores}
\alias{ismt_scores}
\title{Cálculos finales de ISMT -- ISMT final calculations}
\usage{
ismt_scores(df, r, ismt_score = "ismt_pn", grouping = "geocode")
}
\arguments{
\item{df}{objeto \code{data.frame}. Asume que la base de datos ha pasado por \code{cleanup()}, \code{precalc()}, y \code{get_pca()}. || || \code{data.frame} object. Assumes the database has been through \code{cleanup()}, \code{precalc()}, and \code{get_pca()}.}

\item{r}{integer. Número de la región de trabajo. Acepta valores entre 1 y 16; si \code{r = 99}, se utilizan valores a nivel nacional. || || integer. Number of the working region. Accepts values between 1 and 16; if \code{r = 99}, national-level values will be used.}

\item{ismt_score}{string. Nombre del campo del puntaje ISMT, calculado desde \code{get_pca()}. Default es \code{ismt_pn}. || || string. Name of the ISMT sscore field, as calculated from \code{get_pca()]}. Default is \code{ismt_pn}.}

\item{grouping}{string. Nombre del campo con la variable de la unidad espacial agrupadora. Default es \code{geocode}. || || string. Name of the field with the spacial grouping unit variable. Default is \code{geocode}.}
}
\value{
objeto \code{data.frame} agrupado por la unidad espacial especificada con información de ISMT. || || \code{data.frame} object grouped by the specified spatial unit with ISMT information.
}
\description{
Ejecuta los cálculos finales de ISMT. Define los grupos socioeconómicos por unidad territorial y los cuantifica en varias categorías. || || Executes the final ISMT calculations. Defines the socio-economic groups and quantifies them in several categories.
}
\examples{
 data(c17_example)
 clean <- c17_example |> literalize(2017) |> cleanup() |> precalc() |> get_pca() |> ismt_scores(10)
}
