% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_scenario_master.R
\name{read.scenario_master}
\alias{read.scenario_master}
\title{Read and inspect scenario master files}
\usage{
read.scenario_master(
  workdir,
  scenario_master_file,
  isobxr_master_file = "0_ISOBXR_MASTER"
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{scenario_master_file}{Name of \strong{\emph{scenario excel master file}}.
(without file "xlsx" extension).}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}.
(without file "xlsx" extension).
Default is "0_ISOBXR_MASTER".}
}
\value{
List of formatted scenario master inputs.
}
\description{
A function to read and inspect the scenario master files
and obtain a master formatted list.
}
\examples{
read.scenario_master(workdir = "/Users/username/Documents/1_ABC_tutorial",
                     scenario_master_file = "0_SCENARIO_source_change",
                     isobxr_master_file = "0_ISOBXR_MASTER")

}
