% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_predictions.R
\name{tidy_dpp}
\alias{tidy_dpp}
\title{Prepare tidy data and posterior predictions}
\usage{
tidy_dpp(model, fit, draw = NULL, cores = NULL)
}
\arguments{
\item{model}{A networkModel object.}

\item{fit}{A networkModelStanfit object.}

\item{draw}{Integer, number of draws to sample from the posterior.}

\item{cores}{Number of cores to use for parallel calculations. Default is
\code{NULL}, which means to use the value stored in
\code{options()[["mc.cores"]]} (or 1 if this value is not set).}
}
\value{
A list with y, y_rep and vars.
}
\description{
This function prepares both tidy data from a model and tidy posterior
predictions from a model fit. Having those two tibbles prepared at the same
time allows to merge them to ensure that observed data, predicted data and
original variables other than observations are all in sync when using y and
y_rep objects for bayesplot functions.
}
