% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_optsamplesize_tHp.R
\name{optsamplesize_tHp}
\alias{optsamplesize_tHp}
\title{Compute the optimal sample size for the weighted trimmed or truncated Hochberg procedure}
\usage{
optsamplesize_tHp(
  alpha,
  betavec,
  deltavec,
  rho,
  ninterval = c(2, 2000),
  alphalist = seq(from = 0, to = alpha, by = 0.005)
)
}
\arguments{
\item{alpha}{the significance level}

\item{betavec}{a numeric vector of two values, including one minus the desired power for rejecting H1 and one minus the desired power for rejecting H2}

\item{deltavec}{a numeric vector of two values representing the effect sizes for the two hypotheses}

\item{rho}{the correlation coefficient between two test statistics}

\item{ninterval}{a vector containing the end-points of the interval to be searched for optimal sample size}

\item{alphalist}{a vector of discrete alpha values}
}
\value{
the overall optimal sample size for the weighted trimmed or truncated Hochberg procedure
}
\description{
Compute the optimal sample size for the weighted trimmed or truncated Hochberg procedure
}
\examples{
psivec <- c(0.76, 0.72)
thetavec <- log(psivec)
deltavec <- (-thetavec)/2
result <- optsamplesize_tHp(alpha = 0.05, betavec = c(0.20, 0.10),
deltavec = deltavec , rho = -0.1)
result$nopt
}
\references{
Gou, J., Chang, Y., Li, T., and Zhang, F. (2025). Improved trimmed weighted Hochberg procedures with two endpoints and sample size optimization. Technical Report.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
