% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability.R
\name{probability}
\alias{probability}
\title{Estimate suitability on \code{stars} object using trained \code{isolation.forest} model.}
\usage{
probability(x, vars, offset = 0)
}
\arguments{
\item{x}{(\code{isolation_forest}). It could
be the item \code{model} of \code{POIsotree} made by function \code{\link{isotree_po}}.}

\item{vars}{(\code{stars}) The stack of environmental variables. More specifically,
make sure it has x and y dimensions only, and distribute variables to
attributes of this \code{stars}. Otherwise, the function would stop.}

\item{offset}{(\code{numeric}) The offset to adjust fitted suitability. The default
is zero. Highly recommend to leave it as default.}
}
\value{
a \code{stars} of predicted habitat suitability
}
\description{
Apply an \code{isolation.forest} model on a stars object to calculate
environmental suitability and do quantile stretch to \verb{[0, 1]}.
}
\examples{
\dontrun{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 16))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 10,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, nthreads = 1,
  response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

suit <- probability(mod$model, mod$variables)
}

}
\seealso{
\code{\link{isotree_po}}
}
