% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivo_table_gt.R
\encoding{UTF-8}
\name{ivo_table_gt}
\alias{ivo_table_gt}
\title{Create pretty frequency/contingency GT tables}
\usage{
ivo_table_gt(
  df,
  color = "darkgreen",
  font_name = "Arial",
  caption = NULL,
  subtitle = NULL,
  extra_header = TRUE,
  source_note = NULL,
  mask = NULL,
  missing_string = "(Missing)",
  sums = NULL
)
}
\arguments{
\item{df}{A data frame with 1-3 columns}

\item{color}{A named color or a color HEX code, used for the lines in the table. Defaults to "darkgreen".}

\item{font_name}{The name of the font to be used in the table. Defaults to "Arial".}

\item{caption}{An optional string containing a table title.}

\item{subtitle}{An optional string containing a table subtitle. Only usable together with title.}

\item{extra_header}{Should the variable name be displayed? Defaults to TRUE.}

\item{source_note}{An optional string for a table source note.}

\item{mask}{An optional integer to mask counts below given value.}

\item{missing_string}{A string used to indicate missing values. Defaults to "(Missing)".}

\item{sums}{An optional vector to add sums to "rows" and "cols".}
}
\value{
A stylized \code{GT} table.
}
\description{
\code{ivo_table_gt()} lets you easily create a GT table using pretty fonts and colors.
}
\details{
The functions \code{ivo_table_gt()} takes a \code{data.frame} with 1-3 columns. The order of the columns in the \code{data.frame} will determine where they will be displayed in the table. The first column will always be displayed at the top of the table. If there are more than one column the following 2-3 columns will be displayed to the left in order. To change how the columns are displayed in the table; change the place of the columns in the \code{data.frame} using \code{dplyr::select()}.
}
\examples{
# Generate example data
example_data <- data.frame(
    Year = sample(2020:2023, 50, replace = TRUE),
    A = sample(c("Type 1", "Type 2"), 50, replace = TRUE),
    B = sample(c("Apples", "Oranges", "Bananas"), 50, replace = TRUE),
    C = sample(c("Swedish", "Norwegian", "Chilean"), 50, replace = TRUE)
)

### 1 way tables ###
data1 <- example_data |> dplyr::select(Year)

ivo_table_gt(data1)
ivo_table_gt(data1, extra_header = FALSE) # Remove the header
ivo_table_gt(data1, color = "orange") # Change color on table lines

ivo_table_gt(data1, mask = 15) # Counts below <=15 are masked

# With pipes
example_data |>
    dplyr::select(Year) |>
    ivo_table_gt()

### 2-way tables ###
data2 <- example_data |> dplyr::select(A, B)
data2_swap <- example_data |> dplyr::select(B, A)

# Basic tables:
ivo_table_gt(data2)
ivo_table_gt(data2_swap) # Swap order of the columns
ivo_table_gt(data2, sums = "cols") # Add the sum of each column
ivo_table_gt(data2, sums = "rows") # Add the sum of each row
ivo_table_gt(data2, sums = c("cols", "rows")) # Add the sum of each row and column
ivo_table_gt(data2, caption = "Awesome table") # Add a caption
ivo_table_gt(data2,
    caption = "Awesome table",
    subtitle = "It's really awesome"
) # Add a subtitle for the title

# Masked tables:
ivo_table_gt(data2, mask = 7) # Counts <= 7 are masked
# Row and column sums are also masked:
ivo_table_gt(
    data2,
    mask = 3,
    sums = c("cols", "rows"),
)

# Add a note at the end of the table:
# (colwidths must be set to the number of columns in the table)
ivo_table_gt(data2, source_note = "This is a footnote.")

### 3-way tables ###
data3 <- example_data |> dplyr::select(C, B, Year)

ivo_table_gt(data3)
ivo_table_gt(data3, sums = c("cols", "rows")) # Add the sum of each column and each row

ivo_table_gt(
    data3,
    mask = 3,
    caption = "Values between 1 and 3 are masked."
)
}
\seealso{
{ivo_gt_theme}
}
\author{
Stefan Furne
}
