% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LittlewoodRichardson.R
\name{LRskew}
\alias{LRskew}
\title{Littlewood-Richardson rule for skew Schur polynomial}
\usage{
LRskew(lambda, mu, output = "dataframe")
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}

\item{output}{the type of the output, \code{"dataframe"} or \code{"list"}}
}
\value{
This computes the expression of the skew Schur polynomial
  associated to the skew partition defined by \code{lambda} and \code{mu}
  as a linear combination of Schur polynomials. Every coefficient of this
  linear combination is a positive integer, a so-called
  Littlewood-Richardson coefficient.
  If \code{output="dataframe"},
  the output is a dataframe with two columns: the column \code{coeff} gives
  the coefficients of this linear combination, and the column \code{nu}
  gives the partitions defining the Schur polynomials of this linear
  combination as character strings, e.g. the partition \code{c(4, 3, 1)} is
  given by \code{"[4, 3, 1]"}. If \code{output="list"}, the output is a list
  of lists with two elements. Each of these lists with two elements
  corresponds to a term of the linear combination: the first element, named
  \code{coeff}, is the coefficient, namely the Littlewood-Richardson
  coefficient \eqn{c^{\lambda}_{\mu,\nu}}, where \eqn{\nu} is the integer
  partition given in the second element of the list, named
  \code{nu}, which defines the Schur polynomial of the linear
  combination.
}
\description{
Expression of a skew Schur polynomial as a linear
  combination of Schur polynomials.
}
\examples{
library(jack)
LRskew(lambda = c(4, 2, 1), mu = c(3, 1))
}
