% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocluster_plot.R
\name{cocluster_plot}
\alias{cocluster_plot}
\title{Co-Clustering Heatmap from a Numeric Matrix}
\usage{
cocluster_plot(
  data,
  labels.row = NULL,
  labels.col = NULL,
  colors = "Blues",
  breaks = NULL,
  title = "Clustered Heatmap",
  border.color = "black",
  cell.ratio = 1,
  cluster.rows = TRUE,
  cluster.cols = TRUE,
  clustering.distance.rows = "euclidean",
  clustering.distance.cols = "euclidean",
  row.clustering.method = "complete",
  col.clustering.method = "complete",
  show.row.names = TRUE,
  show.col.names = TRUE,
  fontsize = 8,
  fontsize.row = NULL,
  fontsize.col = NULL,
  display.numbers = FALSE,
  round.digits = 2,
  numbers.color = "black",
  numbers.fontsize = 0.5,
  label.color = "black",
  col.name.angle = 45,
  legend = TRUE,
  legend.labels = NULL,
  show.legend.labels = TRUE,
  ...
)
}
\arguments{
\item{data}{A numeric matrix for the heatmap.}

\item{labels.row}{An optional character vector of new labels for the rows.}

\item{labels.col}{An optional character vector of new labels for the columns.}

\item{colors}{A character string specifying one of the predefined palettes or a custom vector of colors. Predefined options include:
\itemize{
 \item "YlOrRd", "YlOrBr", "YlGnBu", "YlGn", "Reds", "RdPu", "Purples", "PuBu", "PuBuGn", "OrRd", "Oranges", "Greys", "Greens", "GnBu", "BuPu", "BuGn", "Blues"
}
   Defaults to "Blues".}

\item{breaks}{The number of color breaks to use for the palette. Defaults to `NULL`.}

\item{title}{Plot title. Default: "Clustered Heatmap".}

\item{border.color}{Color of cell borders on the heatmap. Use "NA" for no border. Default: "white".}

\item{cell.ratio}{A numeric value defining the cell's height-to-width ratio. A value of 1 creates square cells. A value > 1 creates vertical rectangles, while a value < 1 creates horizontal rectangles. Default is 1.}

\item{cluster.rows}{A logical value indicating whether to cluster rows. Default: `TRUE`.}

\item{cluster.cols}{A logical value indicating whether to cluster columns. Default: `TRUE`.}

\item{clustering.distance.rows}{Distance measure for row clustering. Can be a string ("euclidean", "correlation", etc.) or a pre-calculated distance object. Default: "euclidean".}

\item{clustering.distance.cols}{Distance measure for column clustering. Can be a string ("euclidean", "correlation", etc.) or a pre-calculated distance object. Default: "euclidean".}

\item{row.clustering.method}{Agglomeration method for row clustering (see `?hclust`). Default: "complete".}

\item{col.clustering.method}{Agglomeration method for column clustering (see `?hclust`). Default: "complete".}

\item{show.row.names}{Logical, display row names. Default: TRUE.}

\item{show.col.names}{Logical, display column names. Default: TRUE.}

\item{fontsize}{Base font size for the plot. Default: 8.}

\item{fontsize.row}{Font size for row names. If `NULL`, defaults to `fontsize`.}

\item{fontsize.col}{Font size for column names. If `NULL`, defaults to `fontsize`.}

\item{display.numbers}{Logical determining if the numeric values are also printed to the cells.}

\item{round.digits}{Numeric value. For `display.numbers = TRUE`, this sets the decimal places for all values. Default: 2.}

\item{numbers.color}{Color of the numbers. Default: "black".}

\item{numbers.fontsize}{Font size of the numbers. Default: `fontsize`.}

\item{label.color}{Color of the row and column labels. Default: "black".}

\item{col.name.angle}{Angle for column names. Default: 45.}

\item{legend}{A logical value indicating whether to show the color legend. Default: `TRUE`.}

\item{legend.labels}{A character vector of custom labels for the legend.}

\item{show.legend.labels}{Logical, display legend labels. Default: TRUE.}

\item{...}{\dots}
}
\value{
A `ggplot2` object.
}
\description{
Generates a heatmap with hierarchical clustering applied to rows and columns.
It reorders the input matrix based on clustering results and visualizes the
data.
}
