% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_data}
\alias{plot_data}
\title{Plot Data Function}
\usage{
plot_data(
  data,
  formula = ~1,
  study.label = NULL,
  x.lab = NULL,
  y.lab = "TE",
  title.plot = NULL,
  errbar.width = 0.25,
  label.size = 6,
  forest.color = "blue",
  forest.shape = 19,
  forest.size = 3,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame with columns `TE`, `seTE`, and the covariates.}

\item{formula}{A one-sided formula (e.g., `~ x1 + x2`) for the x-axis variables.
If not provided or `~1`, a forest plot is generated.}

\item{study.label}{A character string specifying the name of the column in `data`
that contains the study labels for the forest plot. If `NULL`,
default labels ("Study 1", "Study 2", etc.) are created.}

\item{x.lab}{A character vector for x-axis labels. Defaults to variable names.}

\item{y.lab}{Text for the y-axis label. Defaults to "TE" or "Study" for forest plots.}

\item{title.plot}{Text for the plot title. Defaults to `NULL`.}

\item{errbar.width}{The width of the error bars for regular plots. Defaults to `0.25`.}

\item{label.size}{A numeric value for the font size of the study labels in the
forest plot. Defaults to `6`.}

\item{forest.color}{The color of the points and error bars in the forest plot. Defaults to "blue".}

\item{forest.shape}{The shape of the points in the forest plot. Defaults to `19` (filled circle).}

\item{forest.size}{The size of the points in the forest plot. Defaults to `3`.}

\item{xlim}{A numeric vector of length 2 for the x-axis limits.}

\item{ylim}{A numeric vector of length 2 for the y-axis limits.}

\item{...}{Additional arguments passed to `geom_point()`.}
}
\value{
A `gridExtra` plot object or a single `ggplot` object.
}
\description{
This function plots the treatment effect (TE) against specified covariates or
creates a forest plot of treatment effects, arranging up to four plots in a grid.
}
