% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jellyfisher.R
\name{jellyfisher}
\alias{jellyfisher}
\title{Creates a Jellyfish plot}
\usage{
jellyfisher(
  tables,
  options = list(),
  controls = "closed",
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{tables}{A named list of data frames. The list must contain the following elements:
\describe{
\item{\code{samples}}{A data frame with sample data. The expected columns are:
\describe{
\item{sample}{specifies the unique identifier for each sample. (string)}
\item{displayName}{allows for specifying a custom name for each sample. If the column is omitted, the \code{sample} column is used as the display name. (string, optional)}
\item{rank}{specifies the position of each sample in the Jellyfish plot. For example, different stages of a disease can be ranked in chronological order: diagnosis (1), interval (2), and relapse (3). The zeroth rank is reserved for the root of the sample tree. Ranks can be any integer, and unused ranks are automatically excluded from the plot. If the \code{rank} column is (integer)}
\item{parent}{identifies the parent sample for each entry. Samples without a specified parent are treated as children of an imaginary root sample. (string)}
}
}
\item{\code{phylogeny}}{A data frame with phylogeny data. The expected columns are:
\describe{
\item{subclone}{specifies subclone IDs, which can be any string. (string)}
\item{parent}{designates the parent subclone. The subclone without a parent is considered the root of the phylogeny. (string)}
\item{color}{specifies the color for the subclone. If the column is omitted, colors will be generated automatically. (string, optional)}
\item{branchLength}{specifies the length of the branch leading to the subclone. The length may be based on, for example, the number of unique mutations in the subclone. The branch length is shown in the Jellyfish plot's legend as a bar chart. It is also used when generating a phylogeny-aware color scheme. (number)}
}
}
\item{\code{compositions}}{A data frame with subclonal compositions. The expected columns are:
\describe{
\item{sample}{specifies the sample ID. (string)}
\item{subclone}{specifies the subclone ID. (string)}
\item{clonalPrevalence}{specifies the clonal prevalence of the subclone in the sample. The clonal prevalence is the proportion of the subclone in the sample. The clonal prevalences in a sample must sum to 1. (number)}
}
}
\item{\code{ranks}}{An optional data frame with ranks. The expected columns are:
\describe{
\item{rank}{specifies the rank number. The zeroth rank is reserved for the inferred root of the sample tree. However, you are free to define a title for it. (integer)}
\item{title}{specifies the title for the rank. (string)}
}
}
}}

\item{options}{A named list of options to configure the plot. Available options:
\describe{
\item{crossingWeight}{Weight for tentacle bundles between two pairs of samples crossing each other. Defaults to \code{10}.}
\item{pathLengthWeight}{Weight for the total length of the paths (tentacle bundles) connecting samples. Defaults to \code{2}.}
\item{orderMismatchWeight}{Weight for the mismatch in the order of samples. The order is based on the "phylogenetic center of mass" computed from the subclonal compositions. Defaults to \code{2}.}
\item{bundleMismatchWeight}{Weight for the mismatch in the placement of bundles. The "optimal" placement is based on the subclonal compositions, but such placement may produce excessively long tentacle bundles. Defaults to \code{3}.}
\item{divergenceWeight}{Weight for the sum of divergences between adjacent samples. Defaults to \code{4}.}
\item{bellTipShape}{The shape of the bell tip. 0 is a sharp tip, 1 is a blunt tip. Defaults to \code{0.1}.}
\item{bellTipSpread}{How much to spread nested bell tips. 0 is no spread, 1 is full spread. Defaults to \code{0.5}.}
\item{bellStrokeWidth}{The width of strokes in the bell. Defaults to \code{1}.}
\item{bellStrokeDarkening}{How much the stroke color of the bells is darkened. Defaults to \code{0.6}.}
\item{bellPlateauPos}{Where the bell has fully appeared and the plateau starts. Defaults to \code{0.75}.}
\item{sampleHeight}{Height of real sample nodes Defaults to \code{110}.}
\item{sampleWidth}{Width of sample nodes Defaults to \code{90}.}
\item{inferredSampleHeight}{Height of inferred sample nodes Defaults to \code{120}.}
\item{gapHeight}{Height of gaps between samples. Gaps are routes for tentacle bundles. Defaults to \code{60}.}
\item{sampleSpacing}{Vertical space between samples Defaults to \code{60}.}
\item{columnSpacing}{Horizontal space between columns Defaults to \code{90}.}
\item{tentacleWidth}{Width of tentacles in pixels Defaults to \code{2}.}
\item{tentacleSpacing}{Space between tentacles in a bundle, in pixels Defaults to \code{5}.}
\item{inOutCPDistance}{Relative distance of tentacle control points from the edge of the sample node Defaults to \code{0.3}.}
\item{bundleCPDistance}{Relative distance of tentacle bundle's control points. The higher the value, the longer the individual tentacles stay together before diverging. Defaults to \code{0.6}.}
\item{sampleFontSize}{Font size for sample labels Defaults to \code{12}.}
\item{showLegend}{Whether to show the legend Defaults to \code{TRUE}.}
\item{phylogenyColorScheme}{Whether to use a color scheme based on phylogeny Defaults to \code{TRUE}.}
\item{phylogenyHueOffset}{Offset for the hue of the phylogeny color scheme. If the automatically generated hues are not to your liking, you can adjust the hue offset to get a different color scheme. Defaults to \code{0}.}
\item{sampleTakenGuide}{Type of the "sample taken" guide. \code{"none"} for no guides, \code{"line"} for a faint dashed line in all samples, \code{"text"} same as line, but with a text label in one of the samples. \code{"text-all"} same as text, but with a text label in all samples. Defaults to \code{"text"}.}
\item{showRankTitles}{Whether to show rank titles above the samples (if provided). Defaults to \code{TRUE}.}
\item{normalsAtPhylogenyRoot}{Whether the root of the phylogenetic tree contains normal cells. If true, no tentacles will be drawn for the root clone and its color will be white if phylogenyColorScheme is used. Defaults to \code{FALSE}.}
}}

\item{controls}{An optional parameter to set the initial state of the controls. Can be "open", "closed", or "hidden".}

\item{width}{The width of the widget}

\item{height}{The height of the widget}

\item{elementId}{An optional element ID for the widget}
}
\value{
A Jellyfish plot HTML widget
}
\description{
Creates a Jellyfish plot from samples, a phylogeny, and subclonal compositions.
}
\details{
The format of the data frames is described with examples in Jellyfish documentation:
https://github.com/HautaniemiLab/jellyfish?tab=readme-ov-file#input-data
}
\examples{
# Plot the bundled example data
jellyfisher(jellyfisher_example_tables,
            options = list(
              sampleHeight = 70,
              sampleTakenGuide = "none",
              showLegend = FALSE
            ))

}
