% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Geom.R
\name{Geom}
\alias{Geom}
\alias{d,Geom,numeric-method}
\alias{p,Geom,numeric-method}
\alias{qn,Geom,numeric-method}
\alias{r,Geom,numeric-method}
\alias{mean,Geom-method}
\alias{median,Geom-method}
\alias{mode,Geom-method}
\alias{var,Geom-method}
\alias{sd,Geom-method}
\alias{skew,Geom-method}
\alias{kurt,Geom-method}
\alias{entro,Geom-method}
\alias{finf,Geom-method}
\alias{llgeom}
\alias{ll,Geom,numeric-method}
\alias{egeom}
\alias{mle,Geom,numeric-method}
\alias{me,Geom,numeric-method}
\alias{vgeom}
\alias{avar_mle,Geom-method}
\alias{avar_me,Geom-method}
\title{Geometric Distribution}
\usage{
Geom(prob = 0.5)

\S4method{d}{Geom,numeric}(distr, x, log = FALSE)

\S4method{p}{Geom,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Geom,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Geom,numeric}(distr, n)

\S4method{mean}{Geom}(x)

\S4method{median}{Geom}(x)

\S4method{mode}{Geom}(x)

\S4method{var}{Geom}(x)

\S4method{sd}{Geom}(x)

\S4method{skew}{Geom}(x)

\S4method{kurt}{Geom}(x)

\S4method{entro}{Geom}(x)

\S4method{finf}{Geom}(x)

llgeom(x, prob)

\S4method{ll}{Geom,numeric}(distr, x)

egeom(x, type = "mle", ...)

\S4method{mle}{Geom,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Geom,numeric}(distr, x, na.rm = FALSE)

vgeom(prob, type = "mle")

\S4method{avar_mle}{Geom}(distr)

\S4method{avar_me}{Geom}(distr)
}
\arguments{
\item{prob}{numeric. Probability of success.}

\item{distr}{an object of class \code{Geom}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Geom}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Geometric distribution is a discrete probability distribution that models
the number of failures before the first success in a sequence of independent
Bernoulli trials, each with success probability \eqn{0 < p \leq 1}.
}
\details{
The probability mass function (PMF) of the Geometric distribution is:
\deqn{ P(X = k) = (1 - p)^k p, \quad k \in \mathbb{N}_0.}
}
\examples{
# -----------------------------------------------------
# Geom Distribution Example
# -----------------------------------------------------

# Create the distribution
p <- 0.4
D <- Geom(p)

# ------------------
# dpqr Functions
# ------------------

d(D, 0:4) # density function
p(D, 0:4) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llgeom(x, p)

egeom(x, type = "mle")
egeom(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("geom", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vgeom(p, type = "mle")
vgeom(p, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dgeom]{dgeom()}}, \code{\link[=pgeom]{pgeom()}}, \code{\link[=qgeom]{qgeom()}},
\code{\link[=rgeom]{rgeom()}}
}
