% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_tools.R
\name{check_optim}
\alias{check_optim}
\title{Check Optim Arguments}
\usage{
check_optim(par0, method, lower, upper, choices = NULL, len = 1)
}
\arguments{
\item{par0}{numeric or character. If numeric, it is passed to optim as the
initial estimation, i.e. the \code{par} argument. If character, the corresponding
estimation method is called and the result is passed to optim instead.}

\item{method, lower, upper}{arguments passed to optim.}

\item{choices}{character. A vector of available estimation methods for the
\code{par0} argument}

\item{len}{integer. The appropriate length of the \code{lower} and \code{upper}
argument, as well as \code{par} if it is numeric.}
}
\value{
\code{par0}, possibly altered via \code{match.arg()} if it is a character.
}
\description{
Checks that the arguments supplied by the user are appropriate to be passed
to \code{optim()}. Used internally in parameter estimation.
}
\keyword{internal}
