% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsonstat.R
\name{toJSON.jsonstat.collection}
\alias{toJSON.jsonstat.collection}
\title{Convert JSON-stat collection into JSON}
\usage{
\method{toJSON}{jsonstat.collection}(x, auto_unbox = F)
}
\arguments{
\item{x}{JSON-stat collection}

\item{auto_unbox}{this flag marks atomic vectors in given list as a
singleton, so it will not turn into an 'array' when encoded into JSON.
FALSE by default.}
}
\value{
JSON output
}
\description{
Convert JSON-stat collection into JSON
}
\examples{
library(jsonstat)
library(dplyr)

.plan <- compress_plan("place.of.birth", "geo", "Place of Birth") \%>\%
  dimension("age.group", "classification", "Age Group") \%>\%
  dimension("gender", "classification", "Gender") \%>\%
  dimension("year", "time", "Year") \%>\%
  dimension("province.of.residence", "geo", "Province of Residence") \%>\%
  dimension("concept", "metric", "Concept") \%>\%
  dimension("value", "value", "value")

.dataset <- as.dataset(galicia, .plan,
              label = paste("Population by province of residence,",
                            "place of birth, age, gender and year",
                            "in Galicia"),
              href = "https://github.com/zedoul/jsonstat")

.collection <- as.collection(.dataset, label = "Comparison",
                             href = "https://github.com/zedoul/jsonstat")

.jsonstat <- toJSON(.collection)
}
