% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tapestriExperimentDefinition.R
\name{Custom Slot Getters and Setters}
\alias{Custom Slot Getters and Setters}
\alias{barcodeProbe}
\alias{barcodeProbe,TapestriExperiment-method}
\alias{barcodeProbe<-}
\alias{barcodeProbe<-,TapestriExperiment-method}
\alias{grnaProbe}
\alias{grnaProbe,TapestriExperiment-method}
\alias{grnaProbe<-}
\alias{grnaProbe<-,TapestriExperiment-method}
\alias{gmmParams}
\alias{gmmParams,TapestriExperiment-method}
\title{Getter and Setter functions for \code{TapestriExperiment} slots}
\usage{
barcodeProbe(x)

\S4method{barcodeProbe}{TapestriExperiment}(x)

barcodeProbe(x) <- value

\S4method{barcodeProbe}{TapestriExperiment}(x) <- value

grnaProbe(x)

\S4method{grnaProbe}{TapestriExperiment}(x)

grnaProbe(x) <- value

\S4method{grnaProbe}{TapestriExperiment}(x) <- value

gmmParams(x)

\S4method{gmmParams}{TapestriExperiment}(x)
}
\arguments{
\item{x}{A \code{TapestriExperiment} object}

\item{value}{Character, probe ID to assign to slot}

\item{TapestriExperiment}{A \code{TapestriExperiment} object}
}
\value{
For the getter methods \code{barcodeProbe}, \code{grnaProbe}, and \code{gmmParams}, the value
of the given slot is returned. For the setter methods \code{barcodeProbe} and \code{grnaProbe},
a \code{TapestriExperiment} object is returned with modifications made to the given slot.
}
\description{
Get and set custom slots in \code{TapestriExperiment}. Slots include
\code{barcodeProbe} for a sample barcode probe ID
and \code{grnaProbe} for a gRNA-associated probe ID. These are used as shortcuts for
\code{\link[=moveNonGenomeProbes]{moveNonGenomeProbes()}} and \code{\link[=countBarcodedReads]{countBarcodedReads()}}.
\code{gmmParams} holds parameters and metadata for GMM copy number calling models.
}
\section{Functions}{
\itemize{
\item \code{barcodeProbe(TapestriExperiment)}: barcodeProbe getter

\item \code{barcodeProbe(TapestriExperiment) <- value}: barcodeProbe setter

\item \code{grnaProbe(TapestriExperiment)}: grnaProbe getter

\item \code{grnaProbe(TapestriExperiment) <- value}: grnaProbe setter

\item \code{gmmParams(TapestriExperiment)}: gmmParams getter

}}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
barcodeProbe(tap.object) <- "Probe01"
barcodeProbe(tap.object)

grnaProbe(tap.object) <- "Probe02"
grnaProbe(tap.object)

gmmParams(tap.object)
}
\concept{build experiment}
