% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_kernel.r
\name{discrete_kernel}
\alias{discrete_kernel}
\title{Discrete kernel function}
\usage{
discrete_kernel(
  kernel = c("optimal", "triang", "epanech", "binomial"),
  x,
  z,
  h,
  k = NULL
)
}
\arguments{
\item{kernel}{the type of kernel. Currently supported kernels are limited to:
"optimal", "triang", "epanech" and "binomial"}

\item{x}{the target point at which the density is calculated}

\item{z}{the vector of observations}

\item{h}{the bandwidth (or smoothing parameter)}

\item{k}{Optional: the integer (positive) parameter that defined the support
of the kernel function (corresponds to parameter 'a' for triangular
kernel). It is only used for optimal and triangular kernel}
}
\value{
Returns the value of the associated kernel function
}
\description{
Discrete kernel function
}
\examples{
discrete_kernel(kernel = "optimal", x = 25, z = 1:50, h = 0.9, k = 20)
discrete_kernel(kernel = "triang", x = 25, z = 1:50, h = 10, k = 20)
discrete_kernel(kernel = "epanech", x = 25, z = 1:50, h = 20)
discrete_kernel(kernel = "binomial", x = 25, z = 1:50, h = 0.5)
}
\seealso{
\code{\link[=discrete_optimal]{discrete_optimal()}}, \code{\link[=discrete_triang]{discrete_triang()}}, \code{\link[=discrete_epanech]{discrete_epanech()}},
\code{\link[=discrete_binomial]{discrete_binomial()}}  which this function wraps.
}
