% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_kirby21_data.R
\name{copy_kirby21_data}
\alias{copy_kirby21_data}
\title{Copy Kirby21 Data to an output directory}
\usage{
copy_kirby21_data(copydir, ...)
}
\arguments{
\item{copydir}{Output directory for data}

\item{...}{Arguments to pass to \code{\link{get_image_filenames}}}
}
\value{
Logical if files are copied
}
\description{
Copies files from Kirby21 Package to an output directory
}
\examples{
on_cran = !identical(Sys.getenv("NOT_CRAN"), "true")
on_ci <- nzchar(Sys.getenv("CI"))
local_run = grepl("musch", tolower(Sys.info()[["user"]]))
run_example = !on_cran || on_ci || local_run
if (run_example) {
tdir = tempfile()
dir.create(tdir)
outdir = tempdir()
surv_installed = "kirby21.survey" \%in\% installed.packages()
if (!surv_installed) {
testthat::expect_error(
download_kirby21_data("SURVEY", 
    force = FALSE))
} else {
download_kirby21_data("SURVEY", 
    force = FALSE)
}
res = download_kirby21_data("SURVEY", outdir = outdir, force = TRUE)
if (!surv_installed) {
try({remove.packages("kirby21.survey")})
}
copy_kirby21_data(copydir = tdir, outdir = outdir)
}
}
