% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk_fit.R
\name{rk_fit}
\alias{rk_fit}
\title{nonparametric additive model seleciton via random kernel}
\usage{
rk_fit(
  X,
  y,
  X_k,
  rfn,
  cv_folds,
  rkernel = "laplacian",
  rk_scale = 1,
  rseed = NULL
)
}
\arguments{
\item{X}{design matrix of additive model; rows are observations and columns are variables.}

\item{y}{response of addtive model.}

\item{X_k}{knockoffs matrix of design; the same size as X.}

\item{rfn}{random feature expansion number.}

\item{cv_folds}{the folds of cross-validation for tuning group lasso penalty.}

\item{rkernel}{kernel choices. Default is "laplacian". Other choices are "cauchy" and "gaussian".}

\item{rk_scale}{scaling parameter of sampling distribution for random feature expansion. For gaussian kernel, it is standard deviation of gaussian sampling distribution.}

\item{rseed}{seed for random feature expansion.}
}
\value{
a 0/1 vector indicating selected components.
}
\description{
The function selects additive components via applying group lasso on random feature expansion of data and knockoffs.
}
\examples{
library(knockoff)
p=5 # number of predictors
sig_mag=100 # signal strength
n= 200 # sample size
rkernel="laplacian" # kernel choice
s=2  # sparsity, number of nonzero component functions
rk_scale=1  # scaling paramtere of kernel
rfn= 3  # number of random features
cv_folds=15  # folds of cross-validation in group lasso
X=matrix(rnorm(n*p),n,p)\%*\%chol(toeplitz(0.3^(0:(p-1))))   # generate design
X_k = create.second_order(X) # generate knockoff
reg_coef=c(rep(1,s),rep(0,p-s))  # regression coefficient
reg_coef=reg_coef*(2*(rnorm(p)>0)-1)*sig_mag
y=X\%*\% reg_coef + rnorm(n) # response

# the first half is variables of design X, and the latter is knockoffs X_k
rk_fit(X,y,X_k,rfn,cv_folds,rkernel,rk_scale)


}
\author{
Xiaowu Dai, Xiang Lyu, Lexin Li
}
