% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mvdnorm}
\alias{mvdnorm}
\title{Probability density function of multivariate Gaussian distribution}
\usage{
mvdnorm(x, mu, Sigma)
}
\arguments{
\item{x}{A vector of length \code{d} at which Gaussian density is evaluated.}

\item{mu}{A vector of length \code{d}, mean of Gaussian distribution.}

\item{Sigma}{A \code{d}-by-\code{d} matrix, covariance matrix of Gaussian distribution.}
}
\value{
The probability density of \eqn{N(\mu,\Sigma)} evaluated at \code{x}.
}
\description{
Probability density function of multivariate Gaussian distribution
}
\examples{
# 1D example
mvdnorm(x = 2, mu = 1, Sigma = 2)
dnorm(x = 2, mean = 1, sd = sqrt(2))
# Independent 2D example
mvdnorm(x = c(2,2), mu = c(1,1), Sigma = diag(1:2))
prod(dnorm(x = c(2,2), mean = c(1,1), sd = sqrt(1:2)))
# Correlated 2D example
mvdnorm(x = c(2,2), mu = c(1,1), Sigma = matrix(c(2,1,1,2),nrow=2))
}
