% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgeo_database.R
\name{Rgeo_database}
\alias{Rgeo_database}
\title{Database Construction}
\usage{
Rgeo_database(data, num_fac = 3, property)
}
\arguments{
\item{data}{A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis, see README for details}

\item{num_fac}{A numeric value indicating the number of factors to analyze. Default is 3.}

\item{property}{A string indicating which factor to build variogram from e.g. "RC1" or "RC2"}
}
\value{
A db-class object containing the factors selected with \code{num_fac} and made for use with \code{property}.
}
\description{
Constructs a database from a provided dataset using specified factors.
For more details on the dataset format, see the package README.
}
\details{
The \code{Rgeo_database} function constructs a db-class object from the provided
dataset using the number of factors specified by \code{num_fac} and made for use with \code{property}.
}
\examples{
if(requireNamespace("RGeostats", quietly = TRUE)){
    library(RGeostats)
    data("Klovan_Row80", package = "klovan")
    Rgeo_database(Klovan_Row80, 3, "RC3")
}

}
