% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{as.mcmc.krige}
\alias{as.mcmc.krige}
\alias{as.mcmc.summary.krige}
\title{Convert \code{krige} object to an \code{mcmc} object}
\usage{
\method{as.mcmc}{krige}(x, start = 1, end = x$n.iter, thin = 1, ...)

\method{as.mcmc}{summary.krige}(x, start = 1, end = x$n.iter, thin = 1, ...)
}
\arguments{
\item{x}{An \code{krige} or \code{summary.krige} object.}

\item{start}{The iteration number of the first observation.}

\item{end}{The iteration number of the last observation.}

\item{thin}{The thinning interval between consecutive observations.}

\item{\dots}{Additional arguments to be passed to \code{mcmc()} methods of \code{coda}
package.}
}
\value{
A \code{mcmc} object.
}
\description{
Convert MCMC matrix of posterior samples for use with the \pkg{coda} package
}
\details{
The function converts a \code{krige} output object to a Markov Chain 
  Monte Carlo (mcmc) object used in \code{coda} as well as a variety of MCMC 
  packages. It extracts the MCMC matrix of posterior samples from the output 
  of \code{metropolis.krige} for further use with other MCMC packages and functions.
}
\examples{
\dontrun{
# Summarize Data
summary(ContrivedData)

# Set seed
set.seed(1241060320)

#For simple illustration, we set to few iterations.
#In this case, a 10,000-iteration run converges to the true parameters.
#If you have considerable time and hardware, delete the # on the next line.
#10,000 iterations took 39 min. with 8 GB RAM & a 1.5 GHz Quad-Core processor.
M <- 100
#M<-10000

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
                                  data = ContrivedData, n.iter = M, n.burnin = 20,
                                  range.tol = 0.05)
                                  
# Convert to mcmc object
mcmc.contrived.run <- as.mcmc(contrived.run)
#mcmc.contrived.run <- as.mcmc(summary(contrived.run))

# Diagnostics using MCMC packages
coda::raftery.diag(mcmc.contrived.run)
# superdiag::superdiag(mcmc.contrived.run) #NOT WORKING YET
}

}
\seealso{
\code{\link[coda:as.mcmc]{coda::as.mcmc()}}
}
