# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @useDynLib ksNN, .registration = TRUE
#' @importFrom Rcpp evalCpp
NULL

#' This function calculates the prediction value of k* nearest neighbors algorithm.
#' @param Label vectors of the known labels of the samples.
#' @param Distance vectors of the distance between the target sample we want to predict and the other samples.
#' @param L_C parameter of k* nearest neighbors algorithm.
#' @return the prediction value(pred) and the weight of the samples(alpha).
#' @note This algorithm is based on Anava and Levy(2017).
#' @export
#' @examples
#'   library(ksNN)
#'   set.seed(1)
#'
#'   #make the nonlinear regression problem
#'   X<-runif(100)
#'   Y<-X^6-3*X^3+5*X^2+2
#'
#'   suffle<-order(rnorm(length(X)))
#'   X<-X[suffle]
#'   Y<-Y[suffle]
#'
#'   test_X<-X[1]
#'   test_Y<-Y[1]
#'
#'   train_X<-X[-1]
#'   train_Y<-Y[-1]
#'
#'   Label<-train_Y
#'   Distance<-sqrt((test_X-train_X)^2)
#'
#'   pred_ksNN<-rcpp_ksNN(Label,Distance,L_C=1)
#'
#'   #the predicted value with k*NN
#'   pred_ksNN$pred
#'
#'   #the 'true' value
#'   test_Y
rcpp_ksNN <- function(Label, Distance, L_C = 1.0) {
    .Call(`_ksNN_rcpp_ksNN`, Label, Distance, L_C)
}

