% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labsimplex.R
\name{labsimplex}
\alias{labsimplex}
\title{Generates a simplex object}
\usage{
labsimplex(n, start = NULL, centroid = NULL, stepsize = NULL,
  usrdef = NULL, var.name = NULL)
}
\arguments{
\item{n}{dimensionality of the simplex (i.e. number of variables)}

\item{start}{numeric vector of size \code{n} with coordinates of the
first vertex}

\item{centroid}{numeric vector of size \code{n} with coordinates of the
centroid}

\item{stepsize}{numeric vector of size \code{n} with the step-sizes for
each coordinate}

\item{usrdef}{\code{(n+1)xn} matrix containig in (n+1) rows the n
coordinates for each vertex}

\item{var.name}{vector containing the names for the variables}
}
\value{
An object of class \code{smplx} with the information of the new
  simplex.
}
\description{
The simplex (a list with class \code{smplx}) contains the coordinates
of the n+1 vertices that define a simplex in an \emph{n}-dimensional space.
By default, the function produces a regular simplex centered at the origin.
The coordinates of the regular simplex are transformed into the real
variables space by using the information of the start or centroid and
step-size. The only non-optional parameter is \code{n} that relates the
simplex dimensionality. Once the simplex
is generated, the experiments under the conditions indicated for each
variable at each vertex must be carried and the response obtained.
Those responses are assigned to the \code{smplx} object at the moment of
generating the new vertex (see \code{\link{generateVertex}}).
}
\details{
The regular simplex coordinates are generated following the general
algorithm for the cartesian coordinates of a regular n-dimensional simplex.
This algorithm considers that all vertices must be equally distanced from
simplex centroid and all angles subtended between any two vertexes and the
centroid of a simplex are equal to \emph{arccos(-1/n)}.\cr
If the vertexes coordinates are manually given (in \code{usr.def}
parameter), the function checks if the faces produced belong to different
hyperplanes. This avoids the generation of a degenerated simplex.
}
\examples{
  simplex <- labsimplex(n = 3)
  simplex <- labsimplex(n = 3, centroid = c(350, 7, 0.4),
                        stepsize = c(35, 2, 0.3),
                        var.name = c('temperature', 'pH', 'concentration'))
  simplex <- labsimplex(n = 3, usrdef = rbind(c(390, 8, 0.2), c(330, 8, 0.2),
                                   c(330, 6, 0.6), c(330, 6, 0.1)))
  \dontrun{
    ## User defined coordinates may define a degenerated simplex:
    simplex <- labsimplex(n = 3,
                          usrdef = rbind(c(390, 8, 0.3), c(340, 8, 0.3),
                                         c(355, 8, 0.3), c(340, 5, 0.1)))
  }
}
\references{
Nelder, J. A., and R. Mead. 1965. “A Simplex Method for Function
Minimization.” The Computer Journal 7 (4): 308–13.

Spendley, W., G. R. Hext, and F. R0. Himsworth. 1962. “Sequential
Application of Simplex Designs in Optimization and Evolutionary Operation.”
Technometrics 4 (4): 441–61.
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
