% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.smplx.R
\name{plot.smplx}
\alias{plot.smplx}
\title{Draws a two dimentional plot of the vertexes in a simplex}
\usage{
\method{plot}{smplx}(x, sel.dim = NULL, all.ver = TRUE, all.lin = TRUE,
  expand = TRUE, exp.fac = 1.5, ...)
}
\arguments{
\item{x}{object of class \code{smplx}.}

\item{sel.dim}{\code{numeric} or \code{char} vector for variables to be
considered when simplex dimensionality is higher than 2.
By default, the first two are chosen. If the vector is
\code{numeric}, it must contain the ordinal numbers
corresponding to the desired variables. If the vector is of
class \code{char}, it must contain the names of such
dimensions.}

\item{all.ver}{logical default to \code{TRUE}. Should all vertexes be
plotted? If \code{FALSE}, the function draws only the
vertexes of the current simplex.}

\item{all.lin}{logical default to \code{TRUE}. Should all lines be drawn?
If \code{FALSE}, the function draws only the lines of the
last simplex.}

\item{expand}{logical default to \code{TRUE}. Should the plot scales be
expanded?}

\item{exp.fac}{expansion factor used when \code{expand = TRUE}.}

\item{...}{other graphical parameters used in
\code{\link[graphics]{plot}}}
}
\value{
2D plot of the simplex coordinates.
}
\description{
The function generates a 2D plot of the vertexes in a simplex optimization
when simplex dimensionality is at least 2. When dimensionality is higher
than 2, the plot produced is a projection of the selected variables.
}
\details{
For 3D representations of simplexes with dimensionality higher than 2 you
can use \code{\link{plotSimplex3D}}.
}
\examples{
  plot(x = labsimplex(n = 2, centroid = c(7, 340), stepsize = c(1.2, 15)))

  ## Several options are posible when visualizing higher order simplexes
  plot(x = labsimplex(n = 3))
  plot(x = labsimplex(n = 3), sel.dim = c(2, 3))

  ## Simplex movements can be visualized after some experiments has been
  ## performed
  simplex <- exampleOptimization(surface = exampleSurfaceR2,
                                 centroid = c(7, 340),
                                 stepsize = c(1.2, 15), experiments = 16)
  plot(x = simplex)
}
\seealso{
\code{\link{plotSimplex3D}}
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
