% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampleOptim.R
\name{prspctv}
\alias{prspctv}
\title{3D perspective plot of example response surfaces}
\usage{
prspctv(surface, length = 45, noise = 0, x1lim = c(278, 365),
  x2lim = c(0, 14), par = NULL, theta = 22, phi = 15, shade = 0.2,
  ticktype = "detailed", ...)
}
\arguments{
\item{surface}{example response surface to use. See
\code{\link{exampleSurfaceR2}} and
\code{\link{exampleSurfaceR2.2pks}}.}

\item{length}{number of levels to use in each explanatory variables}

\item{noise}{absolute noise to be included in the results}

\item{x1lim}{limits for the first variable (temperature in
\code{\link{exampleSurfaceR2}} and
\code{\link{exampleSurfaceR2.2pks}})}

\item{x2lim}{limits for the second variable (pH in
\code{\link{exampleSurfaceR2}} and
\code{\link{exampleSurfaceR2.2pks}})}

\item{par}{list with graphical parameters (\code{\link[graphics]{par}}).}

\item{theta}{angles defining the viewing direction.
    \code{theta} gives the azimuthal direction and \code{phi}
    the colatitude.}

\item{phi}{angles defining the viewing direction.
    \code{theta} gives the azimuthal direction and \code{phi}
    the colatitude.}

\item{shade}{the shade at a surface facet is computed as
    \code{((1+d)/2)^shade}, where \code{d} is the dot product of
    a unit vector normal to the facet and a unit vector in the
    direction of a light source.  Values of \code{shade} close
    to one yield shading similar to a point light source model
    and values close to zero produce no shading.  Values in the
    range 0.5 to 0.75 provide an approximation to daylight
    illumination.}

\item{ticktype}{character: \code{"simple"} draws just an arrow
    parallel to the axis to indicate direction of increase;
    \code{"detailed"} draws normal ticks as per 2D plots.}

\item{...}{additional \link[graphics]{graphical parameters} (see \code{\link[graphics]{par}}).}
}
\description{
Plots a \code{\link[graphics]{persp}} plot of the bivariate
example response surfaces included in the package.
}
\examples{
  prspctv(surface = exampleSurfaceR2.2pks)
  prspctv(surface = exampleSurfaceR2.2pks, theta = 35, phi = 25,
          expand = 0.75, xlab = 'Temperature (K)', ylab = 'pH',
          zlab = 'Yield (\%)')
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
