% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambdaTS.R, R/main.R
\docType{package}
\name{lambdaTS}
\alias{lambdaTS}
\alias{lambdaTS-package}
\title{lambdaTS: Variational Seq2Seq Lambda Transformer Model for Time Series Analysis}
\usage{
lambdaTS(
  data,
  target,
  future,
  past = future,
  ci = 0.8,
  deriv = 1,
  yjt = TRUE,
  shift = 0,
  smoother = FALSE,
  k_embed = 30,
  r_proj = ceiling(k_embed/3) + 1,
  n_heads = 1,
  n_bases = 1,
  activ = "linear",
  loss_metric = "elbo",
  optim = "adam",
  epochs = 30,
  lr = 0.01,
  patience = epochs,
  verbose = TRUE,
  sample_n = 100,
  seed = 42,
  dev = "cpu",
  starting_date = NULL,
  dbreak = NULL,
  days_off = NULL,
  min_set = future,
  holdout = 0.5,
  batch_size = 30
)
}
\arguments{
\item{data}{A data frame with ts on columns and possibly a date column (not mandatory)}

\item{target}{String. Time series names to be jointly analyzed within the seq2seq model}

\item{future}{Positive integer. The future dimension with number of time-steps to be predicted}

\item{past}{Positive integer. The past dimension with number of time-steps in the past used for the prediction. Default: future}

\item{ci}{Confidence interval. Default: 0.8}

\item{deriv}{Positive integer. Number of differentiation operations to perform on the original series. 0 = no change; 1: one diff; 2: two diff, and so on.}

\item{yjt}{Logical. Performing Yeo-Johnson Transformation on data is always advisable, especially when dealing with different ts at different scales. Default: TRUE}

\item{shift}{Vector of positive integers. Allow for target variables to shift ahead of time. Zero means no shift. Length must be equal to the number of targets. Default: 0.}

\item{smoother}{Logical. Perform optimal smooting using standard loess. Default: FALSE}

\item{k_embed}{Positive integer. Number of Time2Vec embedding dimensions. Minimum value is 2. Default: 30}

\item{r_proj}{Positive integer. Number of dimensions for the reduction space (to reduce quadratic complexity). Must be largely less than k_embed size. Default: ceiling(k_embed/3) + 1}

\item{n_heads}{Positive integer. Number of heads for the attention mechanism. Computationally expensive, use with care. Default: 1}

\item{n_bases}{Positive integer. Number of normal curves to build on each parameter. Computationally expensive, use with care. Default: 1}

\item{activ}{String. The activation function for the linear transformation of the attention matrix into the future sequence. Implemented options are: "linear", "leaky_relu", "celu", "elu", "gelu", "selu", "softplus", "bent", "snake", "softmax", "softmin", "softsign", "sigmoid", "tanh", "tanhshrink", "swish", "hardtanh", "mish". Default: "linear".}

\item{loss_metric}{String. Loss function for the variational model. Two options: "elbo" or "crps". Default: "crps".}

\item{optim}{String. Optimization methods available are: "adadelta", "adagrad", "rmsprop", "rprop", "sgd", "asgd", "adam". Default: "adam".}

\item{epochs}{Positive integer. Default: 30.}

\item{lr}{Positive numeric. Learning rate. Default: 0.01.}

\item{patience}{Positive integer. Waiting time (in epochs) before evaluating the overfit performance. Default: epochs.}

\item{verbose}{Logical. Default: TRUE}

\item{sample_n}{Positive integer. Number of samples from the variational model to evalute the mean forecast values. Computationally expensive, use with care. Default: 100.}

\item{seed}{Random seed. Default: 42.}

\item{dev}{String. Torch implementation of computational platform: "cpu" or "cuda" (gpu). Default: "cpu".}

\item{starting_date}{Date. Initial date to assign temporal values to the series. Default: NULL (progressive numbers).}

\item{dbreak}{String. Minimum time marker for x-axis, in liberal form: i.e., "3 months", "1 week", "20 days". Default: NULL.}

\item{days_off}{String. Weekdays to exclude (i.e., c("saturday", "sunday")). Default: NULL.}

\item{min_set}{Positive integer. Minimun number for validation set in case of automatic resize of past dimension. Default: future.}

\item{holdout}{Positive numeric. Percentage of time series for holdout validation. Default: 0.5.}

\item{batch_size}{Positive integer. Default: 30.}
}
\value{
This function returns a list including:
\itemize{
\item prediction: a table with quantile predictions, mean and std for each ts
\item history: plot of loss during the training process for the joint-transformed ts
\item plot: graph with history and prediction for each ts
\item learning_error: errors for the joint-ts in the transformed scale (rmse, mae, mdae, mpe, mape, smape, rrse, rae)
\item feature_errors: errors for each ts in the original scale (rmse, mae, mdae, mpe, mape, smape, rrse, rae)
\item pred_stats: for each predicted time feature, IQR to range, KL-divergence, risk ratio, upside probability, averaged across time-points and compared at the terminal points.
\item time_log
}
}
\description{
Time series analysis based on Lambda Transformer and Variational Seq2Seq, built on 'Torch'.
}
\examples{
\dontrun{
lambdaTS(bitcoin_gold_oil, c("gold_close", "oil_Close"), 30, deriv = 1)
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
