% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_shape_cv.R
\name{lsm_c_shape_cv}
\alias{lsm_c_shape_cv}
\title{SHAPE_CV (class level)}
\usage{
lsm_c_shape_cv(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Covariance of variation shape index (Shape metric)
}
\details{
\deqn{SHAPE_{CV} = cv(SHAPE[patch_{ij}])}
where \eqn{SHAPE[patch_{ij}]} is the shape index of each patch.

SHAPE_CV is a 'Shape metric'. Each class is summarised as the Coefficient of variation
of each patch belonging to class i. SHAPE describes the ratio between the actual perimeter of
the patch and the square root of patch area.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{None}
\subsection{Range}{SHAPE_CV >= 0}
\subsection{Behaviour}{Equals SHAPE_CV = 0 if all patches have an identical shape index.
Increases, without limit, as the variation of the shape index increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_shape_cv(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_p_shape}}, \cr
\code{\link{lsm_c_shape_mn}},
\code{\link{lsm_c_shape_sd}}, \cr
\code{\link{lsm_l_shape_mn}},
\code{\link{lsm_l_shape_sd}},
\code{\link{lsm_l_shape_cv}}
}
