% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{inoculumToMatrix}
\alias{inoculumToMatrix}
\title{Inoculum To Matrix}
\usage{
inoculumToMatrix(params)
}
\arguments{
\item{params}{a LandsepiParams object.}
}
\value{
a 3D array of structure (1:Nhost,1:Npatho,1:Npoly)
}
\description{
Transform the inoculum pI0 (1D vector of length Nhost\emph{Npatho}Npoly) into
a 3D array (for visualization purpose)
}
\details{
After defining the inoculum with \code{setInoculum()}, this function returns
the inoculum as a 3D array.
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setTime(simul_params, Nyears = 1, nTSpY = 80)
simul_params <- setPathogen(simul_params, loadPathogen(disease = "rust"))
simul_params <- setLandscape(simul_params, loadLandscape(id = 1))
simul_params <- setDispersalPathogen(simul_params, loadDispersalPathogen(id = 1)[[1]])
gene1 <- loadGene(name = "MG 1", type = "majorGene")
gene2 <- loadGene(name = "MG 2", type = "majorGene")
genes <- data.frame(rbind(gene1, gene2), stringsAsFactors = FALSE)
simul_params <- setGenes(simul_params, genes)
cultivar1 <- loadCultivar(name = "Susceptible", type = "wheat")
cultivar2 <- loadCultivar(name = "Resistant", type = "wheat")
cultivars <- data.frame(rbind(cultivar1, cultivar2), stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)
simul_params <- allocateCultivarGenes(simul_params, "Resistant", c("MG 1", "MG 2"))
croptypes <- loadCroptypes(simul_params, names = c("Susceptible crop", "Resistant crop"))
croptypes <- allocateCroptypeCultivars(croptypes, "Susceptible crop", "Susceptible")
croptypes <- allocateCroptypeCultivars(croptypes, "Resistant crop", c("Resistant"))
simul_params <- setCroptypes(simul_params, croptypes)
simul_params@Croptypes
simul_params <- allocateLandscapeCroptypes(simul_params, rotation_period = 0
, rotation_sequence = croptypes$croptypeID
, prop = c(1/2,1/2), aggreg = 1, graphic = FALSE)
pI0 <- loadInoculum(simul_params, pI0_patho=c(1E-3,1E-4,1E-4,1E-5), pI0_host=c(1,1))
simul_params <- setInoculum(simul_params, pI0)
inoculumToMatrix(simul_params)[,,1:5]
}
}
\seealso{
\link{setInoculum}
}
