% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/languageserver_startup.R
\name{languageserver_startup}
\alias{languageserver_startup}
\title{Prepare language server to be started}
\usage{
languageserver_startup(rlsLib = getOption("langserver_library"),
  langServerProcessPatt = getOption("langserver_processPatt"),
  strictLibrary = TRUE, os = tolower(Sys.info()[["sysname"]]),
  pid = Sys.getpid())
}
\arguments{
\item{rlsLib}{\code{character(1)}, path to the library where the
\code{languageserver} package will be installed.}

\item{langServerProcessPatt}{\code{character(1)}, pattern to
recognize the process created by \code{languageserver}.}

\item{strictLibrary}{\code{logical(1)}, if \code{TRUE}, all the dependencies
of \code{languageserver} will be installed into \code{rlsLib}, otherwise
only those that are needed but not present in other libraries
in \code{.libPaths()} will be installed.}

\item{os}{\code{character(1)}, name of the OS, usually retrieved
as the \code{"sysname"} element of \code{Sys.info}, all lowercase.}

\item{pid}{\code{integer(1)}, id of the process to investigate,
usually retrieved by \code{Sys.getpid}}
}
\value{
side-effects
}
\description{
Prepare language server to be started
}
