% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.R
\name{fb_ads}
\alias{fb_ads}
\title{Facebook Ads API}
\usage{
fb_ads(
  token,
  which,
  start_date = Sys.Date() - 31,
  end_date = Sys.Date(),
  fields = NA,
  api_version = NULL,
  process = TRUE,
  ...
)
}
\arguments{
\item{token}{Character. Valid access token with sufficient privileges. Visit the
\href{https://developers.facebook.com/tools/explorer}{Facebook API Graph Explorer}
to acquire one.}

\item{which}{Character vector. This is the accounts, campaigns, adsets,
or ads IDs to be queried. Remember: if \code{report_level = "account"}, you must
start the ID with \code{act_}.}

\item{start_date, end_date}{Character. The first and last full day to report, in the
format \code{"YYYY-MM-DD"}.}

\item{fields}{Character, json format. Leave \code{NA} for default fields OR
\code{NULL} to ignore.}

\item{api_version}{Character. Facebook API version.}

\item{process}{Boolean. Process GET results to a more friendly format?}

\item{...}{Additional parameters.}
}
\value{
data.frame with un-nested processed results if \code{process=TRUE} or
raw API results as list when \code{process=FALSE}.
}
\description{
This returns all available FB ads for any account, campaign, or ad set id.
For more information on Ad' API, go to the
\href{https://developers.facebook.com/docs/marketing-api/reference/adgroup}{original documentaion}
}
\details{
This function was based on FBinsightsR.
}
\examples{
\dontrun{
token <- YOURTOKEN
account <- act_ADACCOUNT

# Query all ads for "which" (account) with results in the last 10 days
ads <- fb_ads(token, account, start_date = Sys.Date() - 10)
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_process}()},
\code{\link{fb_report_check}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{gemini_ask}()},
\code{\link{gpt_ask}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other Meta: 
\code{\link{fb_accounts}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_process}()},
\code{\link{fb_report_check}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()}
}
\concept{API}
\concept{Meta}
