% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indirect.R
\name{indirect}
\alias{indirect}
\title{Inference on Average Indirect Effect Parameters}
\usage{
indirect(Y, D, Z, S, A, K = 1, bw = NULL, B = NULL, alp = 0.05)
}
\arguments{
\item{Y}{An n-dimensional outcome vector}

\item{D}{An n-dimensional binary treatment vector}

\item{Z}{An n-dimensional binary instrumental vector}

\item{S}{An n-dimensional logical vector to indicate whether each unit
belongs to the sub-population S}

\item{A}{An n times n symmetric binary adjacency matrix}

\item{K}{A scalar to indicate the range of neighborhood
used for constructing the interference set.
Default is 1.}

\item{bw}{A scalar of the bandwidth used for the HAC estimation and
the wild bootstrap.
If \code{bw = NULL}, the rule-of-thumb bandwidth proposed by Leung (2022) is used.
Default is NULL.}

\item{B}{The number of bootstrap repetitions.
If \code{B = NULL}, the wild bootstrap is skipped.
Default is NULL.}

\item{alp}{The significance level. Default is 0.05.}
}
\value{
A data.frame containing the following elements:
\item{est}{The parameter estimate}
\item{HAC_SE}{The standard error computed by the network HAC estimation}
\item{HAC_CI_L}{The lower bound of the confidence interval computed by
the network HAC estimation}
\item{HAC_CI_U}{The upper bound of the confidence interval computed by
the network HAC estimation}
\item{wild_SE}{The standard error computed by the wild bootstrap}
\item{wild_CI_L}{The lower bound of the confidence interval computed by
the wild bootstrap}
\item{wild_CI_U}{The upper bound of the confidence interval computed by
the wild bootstrap}
\item{bw}{The bandwidth used for the HAC estimation
and the wild bootstrap}
\item{size}{The size of the subpopulation S}
}
\description{
Inference on the average indirect effect of the IV on the outcome,
that on the treatment receipt, and the local average indirect effect
in the presence of network spillover of unknown form
}
\details{
The \code{indirect()} function estimates the average indirect effect of the IV
on the outcome, that on the treatment receipt, and
the local average indirect effect via inverse probability weighting
in the approximate neighborhood interference framework.
The function also computes the standard errors and the confidence intervals
for the target parameters based on the network HAC estimation and
the wild bootstrap.
For more details, see Hoshino and Yanagi (2023).
The lengths of \code{Y}, \code{D}, \code{Z}, \code{S} and
of the row and column of \code{A} must be the same.
\code{K} must be a positive integer.
\code{bw} must be \code{NULL} or a non-negative number.
\code{B} must be \code{NULL} or a positive number.
\code{alp} must be a positive number between 0 and 0.5.
}
\examples{
# Generate artificial data
set.seed(1)
n <- 2000
data <- latenetwork::datageneration(n = n)

# Arguments
Y   <- data$Y
D   <- data$D
Z   <- data$Z
S   <- rep(TRUE, n)
A   <- data$A
K   <- 1
bw  <- NULL
B   <- NULL
alp <- 0.05

# Estimation
latenetwork::indirect(Y = Y,
                      D = D,
                      Z = Z,
                      S = S,
                      A = A,
                      K = K,
                      bw = bw,
                      B = B,
                      alp = alp)

}
\references{
Hoshino, T., & Yanagi, T. (2023).
Causal inference with noncompliance and unknown interference.
arXiv preprint arXiv:2108.07455.

Leung, M.P. (2022).
Causal inference under approximate neighborhood interference.
Econometrica, 90(1), pp.267-293.
}
