% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{makePreamble}
\alias{makePreamble}
\title{Make a Preamble for a LaTeX Document}
\usage{
makePreamble(
  landscape = FALSE,
  wide = if (landscape) 279.4 else 215.9,
  long = if (landscape) 215.9 else 279.4,
  geoLeft = "1mm",
  geoRight = "1mm",
  geoTop = "1mm",
  geoBottom = "1mm",
  documentclass = command("documentclass", args = "article"),
  xcolorPackage = command("usepackage", options = list("dvipsnames", "svgnames",
    "table"), args = "xcolor"),
  geometryPackage = command("usepackage", options = list(left = geoLeft, top = geoTop,
    bottom = geoBottom, right = geoRight), args = "geometry"),
  geometry = command("geometry", args = list(paste0("papersize=", paste0("{", wide, "mm",
    ",", long, "mm}")))),
  multirow = command("usepackage", args = "multirow"),
  float = command("usepackage", args = "float"),
  longtable = command("usepackage", args = "longtable"),
  inputenc = command("usepackage", options = "utf8", args = "inputenc"),
  fontenc = command("usepackage", options = "T1", args = "fontenc"),
  morePreamble = NULL,
  ...
)
}
\arguments{
\item{landscape}{if TRUE, default orientation is `landscape' not `portrait'}

\item{wide}{page width in mm}

\item{long}{page lenth in mm}

\item{geoLeft}{geometry package: left margin}

\item{geoRight}{geometry package: right margin}

\item{geoTop}{geometry package: top margin}

\item{geoBottom}{geometry package: bottom margin}

\item{documentclass}{document class command}

\item{xcolorPackage}{xcolor package command}

\item{geometryPackage}{geometry package command}

\item{geometry}{geometry specification}

\item{multirow}{multirow specification}

\item{float}{float specification}

\item{longtable}{longtable specification}

\item{inputenc}{input encoding}

\item{fontenc}{output encoding}

\item{morePreamble}{additional preamble before beginning the document}

\item{...}{ignored}
}
\value{
character
}
\description{
Makes a preamble for a LaTeX Document.
}
\examples{
makePreamble()
}
