% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{update.lcModel}
\alias{update.lcModel}
\title{Update a lcModel}
\usage{
\method{update}{lcModel}(object, ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{
  Arguments passed on to \code{\link[=latrend]{latrend}}
  \describe{
    \item{\code{method}}{An \link{lcMethod} object specifying the longitudinal cluster method to apply, or the name (as \code{character}) of the \code{lcMethod} subclass to instantiate.}
    \item{\code{data}}{The data of the trajectories to which to estimate the method for.
Any inputs supported by \code{\link[=trajectories]{trajectories()}} can be used, including \code{data.frame} and \code{matrix}.}
    \item{\code{envir}}{The \code{environment} in which to evaluate the method arguments via \code{\link[=compose]{compose()}}.
If the \code{data} argument is of type \code{call} then this environment is also used to evaluate the \code{data} argument.}
    \item{\code{verbose}}{The level of verbosity. Either an object of class \code{Verbose} (see \link[R.utils:Verbose]{R.utils::Verbose} for details),
a \code{logical} indicating whether to show basic computation information,
a \code{numeric} indicating the verbosity level (see \link[R.utils:Verbose]{R.utils::Verbose}),
or one of \code{c('info', 'fine', 'finest')}.}
  }}
}
\value{
The refitted \code{lcModel} object, of the same type as the \code{object} argument.
}
\description{
Fit a new model with modified arguments from the current model.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model2 <- latrend(method, latrendData, nClusters = 2)

# fit for a different number of clusters
model3 <- update(model2, nClusters = 3)
}
\seealso{
\link{latrend} \link{getCall}
}
