% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-methods.R, R/pool-indices.R
\docType{class}
\name{lavaan.mi-class}
\alias{lavaan.mi-class}
\alias{show,lavaan.mi-method}
\alias{summary,lavaan.mi-method}
\alias{fitMeasures,lavaan.mi-method}
\alias{fitmeasures,lavaan.mi-method}
\alias{nobs,lavaan.mi-method}
\alias{coef,lavaan.mi-method}
\alias{vcov,lavaan.mi-method}
\alias{fitted,lavaan.mi-method}
\alias{fitted.values,lavaan.mi-method}
\title{Class for a lavaan Model Fitted to Multiple Imputations}
\usage{
\S4method{show}{lavaan.mi}(object)

\S4method{summary}{lavaan.mi}(
  object,
  header = TRUE,
  fit.measures = FALSE,
  fm.args = list(standard.test = "default", scaled.test = "default", rmsea.ci.level =
    0.9, rmsea.h0.closefit = 0.05, rmsea.h0.notclosefit = 0.08, robust = TRUE,
    cat.check.pd = TRUE),
  estimates = TRUE,
  ci = FALSE,
  standardized = FALSE,
  std = standardized,
  cov.std = TRUE,
  rsquare = FALSE,
  fmi = FALSE,
  asymptotic = FALSE,
  scale.W = !asymptotic,
  omit.imps = c("no.conv", "no.se"),
  remove.unused = TRUE,
  modindices = FALSE,
  nd = 3L,
  ...
)

\S4method{nobs}{lavaan.mi}(object, total = TRUE)

\S4method{coef}{lavaan.mi}(object, type = "free", labels = TRUE, omit.imps = c("no.conv", "no.se"))

\S4method{vcov}{lavaan.mi}(
  object,
  type = c("pooled", "between", "within", "ariv"),
  scale.W = TRUE,
  omit.imps = c("no.conv", "no.se")
)

\S4method{fitted}{lavaan.mi}(object, omit.imps = c("no.conv", "no.se"))

\S4method{fitted.values}{lavaan.mi}(object, omit.imps = c("no.conv", "no.se"))

\S4method{fitMeasures}{lavaan.mi}(
  object,
  fit.measures = "all",
  baseline.model = NULL,
  h1.model = NULL,
  fm.args = list(standard.test = "default", scaled.test = "default", rmsea.ci.level =
    0.9, rmsea.h0.closefit = 0.05, rmsea.h0.notclosefit = 0.08, robust = 0.08,
    cat.check.pd = TRUE),
  output = "vector",
  omit.imps = c("no.conv", "no.se"),
  ...
)

\S4method{fitmeasures}{lavaan.mi}(
  object,
  fit.measures = "all",
  baseline.model = NULL,
  h1.model = NULL,
  fm.args = list(standard.test = "default", scaled.test = "default", rmsea.ci.level =
    0.9, rmsea.h0.closefit = 0.05, rmsea.h0.notclosefit = 0.08, robust = 0.08,
    cat.check.pd = TRUE),
  output = "vector",
  omit.imps = c("no.conv", "no.se"),
  ...
)
}
\arguments{
\item{object}{An object of class \linkS4class{lavaan.mi}}

\item{header, fit.measures, fm.args, estimates, ci, standardized, std, cov.std, rsquare, remove.unused, modindices, nd, output}{See descriptions of \code{summary()} arguments in the help page for
\link[lavaan:lavaan-class]{lavaan::lavaan} class. Also see \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}} for arguments
\code{fit.measures} and \code{fm.args}.}

\item{fmi}{\code{logical} indicating whether to add the Fraction Missing
Information (FMI) and (average) relative increase in variance (ARIV)
to the output.}

\item{asymptotic}{\code{logical}. If \code{FALSE} (typically a default, but
see \strong{Value} section for details using various methods), pooled
tests (of fit or pooled estimates) will be \emph{F} or \emph{t}
statistics with associated degrees of freedom (\emph{df}). If
\code{TRUE}, the (denominator) \emph{df} are assumed to be
sufficiently large for a \emph{t} statistic to follow a normal
distribution, so it is printed as a \emph{z} statistic; likewise,
\emph{F} times its numerator \emph{df} is printed, assumed to follow
a \eqn{\chi^2} distribution.}

\item{scale.W}{\code{logical}. If \code{TRUE} (default), the \code{vcov}
method will calculate the pooled covariance matrix by scaling the
within-imputation component by the ARIV (see Enders, 2010, p. 235,
for definition and formula). Otherwise, the pooled matrix is
calculated as the weighted sum of the within-imputation and
between-imputation components (see Enders, 2010, ch. 8, for details).
This in turn affects how the \code{summary} method calculates its
pooled standard errors, as well as the Wald test
(\code{\link[=lavTestWald.mi]{lavTestWald.mi()}}).}

\item{omit.imps}{\code{character} vector specifying criteria for omitting
imputations from pooled results.  Can include any of
\code{c("no.conv", "no.se", "no.npd")}, the first 2 of which are the
default setting, which excludes any imputations that did not
converge or for which standard errors could not be computed.  The
last option (\code{"no.npd"}) would exclude any imputations which
yielded a nonpositive definite covariance matrix for observed or
latent variables, which would include any "improper solutions" such
as Heywood cases.  NPD solutions are not excluded by default because
they are likely to occur due to sampling error, especially in small
samples.  However, gross model misspecification could also cause
NPD solutions, users can compare pooled results with and without
this setting as a sensitivity analysis to see whether some
imputations warrant further investigation. Specific imputation
numbers can also be included in this argument, in case users want to
apply their own custom omission criteria (or simulations can use
different numbers of imputations without redundantly refitting the
model).}

\item{...}{Additional arguments passed to \code{\link[=lavTestLRT.mi]{lavTestLRT.mi()}}, or
subsequently to \code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}. This is how users can
specify a \verb{pool.method=} for the model's \eqn{\chi^2} statistic
(optionally used in any \verb{fit.measures=}), or set \code{pool.method="D1"}
when \code{summary(modindices=TRUE)}.}

\item{total}{\code{logical} (default: \code{TRUE}) indicating whether the
\code{nobs()} method should return the total sample size or (if
\code{FALSE}) a vector of group sample sizes.}

\item{type}{The meaning of this argument varies depending on which method it
it used for. Find detailed descriptions in the \strong{Value} section
under \code{coef()} and \code{vcov()}.}

\item{labels}{\code{logical} indicating whether the \code{coef()} output
should include parameter labels. Default is \code{TRUE}.}

\item{baseline.model, h1.model}{See \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}}.}
}
\value{
\item{coef}{\code{signature(object = "lavaan.mi", type = "free", labels = TRUE, omit.imps = c("no.conv","no.se"))}:
See argument description on the help page for \link[lavaan:lavaan-class]{lavaan::lavaan} class.
Returns the pooled point estimates (i.e., averaged across imputed data
sets; see Rubin, 1987).}

\item{vcov}{\code{signature(object = "lavaan.mi", scale.W = TRUE, omit.imps = c("no.conv","no.se"), type = c("pooled","between","within","ariv"))}:  By default, returns the
pooled covariance matrix of parameter estimates (\code{type = "pooled"}),
the within-imputations covariance matrix (\code{type = "within"}), the
between-imputations covariance matrix (\code{type = "between"}), or the
average relative increase in variance (\code{type = "ariv"}) due to
missing data.}

\item{fitted.values}{\code{signature(object = "lavaan.mi", omit.imps = c("no.conv","no.se"))}: See corresponding \link[lavaan:lavaan-class]{lavaan::lavaan} method.
Returns model-implied moments, evaluated at the pooled point estimates.}
\item{fitted}{alias for \code{fitted.values}}

\item{nobs}{\code{signature(object = "lavaan.mi", total = TRUE)}: either
the total (default) sample size or a vector of group sample sizes
(\code{total = FALSE}).}

\item{fitMeasures}{\code{signature(object = "lavaan.mi", fit.measures = "all", baseline.model = NULL, h1.model = NULL, fm.args = list(standard.test = "default", scaled.test = "default", rmsea.ci.level = 0.90, rmsea.h0.closefit = 0.05, rmsea.h0.notclosefit = 0.08, robust = TRUE, cat.check.pd = TRUE), output = "vector", omit.imps = c("no.conv","no.se"), ...)}:
See \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}} for details.
Pass additional arguments to \code{\link[=lavTestLRT.mi]{lavTestLRT.mi()}} via \code{...}.}
\item{fitmeasures}{alias for \code{fitMeasures}.}

\item{show}{\code{signature(object = "lavaan.mi")}: returns a message about
convergence rates and estimation problems (if applicable) across imputed
data sets.}

\item{summary}{\code{signature(object = "lavaan.mi", header = TRUE, fit.measures = FALSE,fm.args = list(standard.test = "default", scaled.test = "default", rmsea.ci.level = 0.90, rmsea.h0.closefit = 0.05, rmsea.h0.notclosefit = 0.08, robust = TRUE, cat.check.pd = TRUE), estimates = TRUE, ci = FALSE, standardized = FALSE, std = standardized, cov.std = TRUE, rsquare = FALSE, fmi = FALSE, asymptotic = FALSE, scale.W = !asymptotic, omit.imps = c("no.conv","no.se"), remove.unused = TRUE, modindices = FALSE, nd = 3L, ...)}:
Analogous to \code{summary()} for \code{lavaan-class} objects.
By default, \code{summary} returns output from \code{\link[=parameterEstimates.mi]{parameterEstimates.mi()}},
with some cursory information in the header.
Setting \code{fit.measures=TRUE} will additionally run \code{fitMeasures()}, and
setting \code{modindices=TRUE} will additionally run \code{\link[=modindices.mi]{modindices.mi()}}.}
}
\description{
This class extends the \link[lavaan:lavaanList-class]{lavaan::lavaanList} class, created by
fitting a lavaan model to a list of data sets. In this case, the list of
data sets are multiple imputations of missing data.
}
\section{Slots}{

\describe{
\item{\code{coefList}}{\code{list} of estimated coefficients in matrix format (one
per imputation) as output by \code{lavInspect(fit, "est")}}

\item{\code{phiList}}{\code{list} of model-implied latent-variable covariance
matrices (one per imputation) as output by
\code{lavInspect(fit, "cov.lv")}}

\item{\code{miList}}{\code{list} of modification indices output by
\code{\link[lavaan:modificationIndices]{lavaan::modindices()}}}

\item{\code{lavListCall}}{call to \code{\link[lavaan:lavaanList]{lavaan::lavaanList()}} used to fit the
model to the list of imputed data sets in \verb{@DataList}, stored as a
\code{list} of arguments}

\item{\code{convergence}}{\code{list} of \code{logical} vectors indicating whether,
for each imputed data set, (1) the model converged on a solution, (2)
\emph{SE}s could be calculated, (3) the (residual) covariance matrix of
latent variables (\eqn{\Psi}) is non-positive-definite, and (4) the
residual covariance matrix of observed variables (\eqn{\Theta}) is
non-positive-definite.}

\item{\code{version}}{Named \code{character} vector indicating the \code{lavaan} and
\code{lavaan.mi} version numbers.}

\item{\code{DataList}}{The \code{list} of imputed data sets}

\item{\code{SampleStatsList}}{List of output from
\code{lavInspect(fit, "sampstat")} applied to each fitted model.}

\item{\code{ParTableList,vcovList,testList,baselineList}}{See \link[lavaan:lavaanList-class]{lavaan::lavaanList}}

\item{\code{h1List}}{See \link[lavaan:lavaanList-class]{lavaan::lavaanList}. An additional element is
added to the \code{list}: \verb{$PT} is the "saturated" model's parameter
table, returned by \code{\link[lavaan:lav_partable]{lavaan::lav_partable_unrestricted()}}.}

\item{\code{call,Options,ParTable,pta,Data,Model,meta,timingList,CacheList,optimList,impliedList,loglikList,internalList,funList,external}}{By default, \code{\link[=lavaan.mi]{lavaan.mi()}} does not populate the remaining \verb{@*List} slots
from the \link[lavaan:lavaanList-class]{lavaan::lavaanList} class. But they can be added to the call using
the \verb{store.slots=} argument (passed to \code{\link[lavaan:lavaanList]{lavaan::lavaanList()}} via \dots).}
}}

\section{Objects from the Class}{
 See the \code{\link[=lavaan.mi]{lavaan.mi()}} function
for details. Wrapper functions include \code{\link[=cfa.mi]{cfa.mi()}},
\code{\link[=sem.mi]{sem.mi()}}, and \code{\link[=growth.mi]{growth.mi()}}.
}

\examples{

data(HS20imps) # import a list of 20 imputed data sets

## specify CFA model from lavaan's ?cfa help page
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'

## fit model to imputed data sets
fit <- cfa.mi(HS.model, data = HS20imps)

## vector of pooled coefficients
coef(fit)
## their pooled asymptotic covariance matrix
vcov(fit)
## which is the weighted sum of within- and between-imputation components
vcov(fit, type = "within")
vcov(fit, type = "between")

## covariance matrix of observed variables,
## as implied by pooled estimates
fitted(fit)

## custom null model for CFI
HS.parallel <- '
  visual  =~ x1 + 1*x2 + 1*x3
  textual =~ x4 + 1*x5 + 1*x6
  speed   =~ x7 + 1*x8 + 1*x9
'
fit0 <- cfa.mi(HS.parallel, data = HS20imps, orthogonal = TRUE)
fitMeasures(fit, baseline.model = fit0, fit.measures = "default",
            output = "text")

## See ?lavaan.mi help page for more examples

}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. New York, NY:
Guilford.

Rubin, D. B. (1987). \emph{Multiple imputation for nonresponse in surveys}.
New York, NY: Wiley. \doi{10.1002/9780470316696}
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})
}
