% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logo.R
\name{addLogo}
\alias{addLogo}
\alias{updateLogo}
\alias{removeLogo}
\alias{hideLogo}
\alias{showLogo}
\title{add a local or remote image (png, jpg, gif, bmp, ...) to a leaflet map}
\usage{
addLogo(
  map,
  img,
  alpha = 1,
  src = NULL,
  url = NULL,
  position = c("topleft", "topright", "bottomleft", "bottomright"),
  offset.x = 50,
  offset.y = 13,
  width = 60,
  height = 60,
  class = NULL,
  layerId = NULL
)

updateLogo(map, img, layerId)

removeLogo(map, layerId)

hideLogo(map, layerId)

showLogo(map, layerId)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{img}{the image to be added to the map.}

\item{alpha}{opacity of the added image.}

\item{src}{DEPRECATED. The function now automatically determines if \code{img} is
a local or remote image using \code{file.exists(img)}.}

\item{url}{an optional URL to be opened when clicking on the image
(e.g. company's homepage).}

\item{position}{one of "topleft", "topright", "bottomleft", "bottomright".}

\item{offset.x}{the offset in x direction from the chosen position (in pixels).}

\item{offset.y}{the offset in y direction from the chosen position (in pixels).}

\item{width}{width of the rendered image in pixels.}

\item{height}{height of the rendered image in pixels.}

\item{class}{optional class}

\item{layerId}{an id for the logo div.}
}
\description{
This function adds an image to a map. Both local and remote (web) image
sources are supported. Position on the map is completely controllable.
}
\examples{
library(leaflet)
## default position is topleft next to zoom control

img <- "https://www.r-project.org/logo/Rlogo.svg"
leaflet() \%>\% addTiles() \%>\% addLogo(img, url = "https://www.r-project.org/logo/")

## with local image
if (requireNamespace("png")) {
  library(png)

  img <- system.file("img", "Rlogo.png", package="png")
  leaflet() \%>\% addTiles() \%>\% addLogo(img, src = "local", alpha = 0.3)

  ## dancing banana gif :-)
  m <- leaflet() \%>\%
    addTiles() \%>\%
    addCircleMarkers(data = breweries91)

  addLogo(m, "https://jeroenooms.github.io/images/banana.gif",
          position = "bottomleft",
          offset.x = 5,
          offset.y = 40,
          width = 100,
          height = 100)
}


}
