% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesic.R
\name{geodesics}
\alias{geodesics}
\alias{addGeodesicPolylines}
\alias{addLatLng}
\alias{addGreatCircles}
\title{Add Geodesic Lines & Circles}
\usage{
addGeodesicPolylines(
  map,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  steps = 10,
  wrap = TRUE,
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  options = pathOptions(),
  highlightOptions = NULL,
  icon = NULL,
  showMarker = FALSE,
  showStats = FALSE,
  statsFunction = NULL,
  markerOptions = NULL,
  data = getMapData(map)
)

addLatLng(map, lat, lng, layerId = NULL)

addGreatCircles(
  map,
  lat_center = NULL,
  lng_center = NULL,
  radius,
  layerId = NULL,
  group = NULL,
  steps = 10,
  wrap = TRUE,
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  options = pathOptions(),
  highlightOptions = NULL,
  icon = NULL,
  fill = TRUE,
  showMarker = FALSE,
  showStats = FALSE,
  statsFunction = NULL,
  markerOptions = NULL,
  data = getMapData(map)
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{lat, lng}{lat/lng to add to the Geodesic}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{steps}{Defines how many intermediate points are generated along the path.
More steps mean a smoother path.}

\item{wrap}{Wrap line at map border (date line). Set to "false" if you want
lines to cross the dateline (experimental, see noWrap-example on how to use)}

\item{stroke}{whether to draw stroke along the path (e.g. the borders of
polygons or circles)}

\item{color}{stroke color}

\item{weight}{stroke width in pixels}

\item{opacity}{stroke opacity (or layer opacity for tile layers)}

\item{dashArray}{a string that defines the stroke
\href{https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray}{dash
pattern}}

\item{smoothFactor}{how much to simplify the polyline on each zoom level
(more means better performance and less accurate representation)}

\item{noClip}{whether to disable polyline clipping}

\item{popup}{a character vector of the HTML content for the popups (you are
recommended to escape the text using \code{\link[htmltools]{htmlEscape}()}
for security reasons)}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{label}{a character vector of the HTML content for the labels}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements}

\item{highlightOptions}{Options for highlighting the shape on mouse over.}

\item{icon}{the icon(s) for markers; an icon is represented by an R list of
the form \code{list(iconUrl = "?", iconSize = c(x, y))}, and you can use
\code{\link[leaflet]{icons}()} to create multiple icons; note when you use an R list
that contains images as local files, these local image files will be base64
encoded into the HTML page so the icon images will still be available even
when you publish the map elsewhere}

\item{showMarker}{Should the nodes/center points be visualized as Markers?}

\item{showStats}{This will create an L.Control with some information on the geodesics}

\item{statsFunction}{A custom JS function to be showed in the info control}

\item{markerOptions}{List of options for the markers. See \code{\link[leaflet]{markerOptions}}}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}

\item{lat_center, lng_center}{lat/lng for the center}

\item{radius}{in meters}

\item{fill}{whether to fill the path with color (e.g. filling on polygons or
circles)}
}
\description{
A geodesic line is the shortest path between two given positions on the
earth surface. It's based on Vincenty's formulae implemented by
\href{https://github.com/chrisveness/geodesy}{Chris Veness} for highest precision.

Add Lat/Long to a Geodesic Polyline.

Adds a Great Circle to the map.
}
\examples{
berlin <- c(52.51, 13.4)
losangeles <- c(34.05, -118.24)
santiago <- c(-33.44, -70.71)
tokio <- c(35.69, 139.69)
sydney <- c(-33.91, 151.08)
capetown <- c(-33.91, 18.41)
calgary <- c(51.05, -114.08)
hammerfest <- c(70.67, 23.68)
barrow <- c(71.29, -156.76)

df <- as.data.frame(rbind(hammerfest, calgary, losangeles, santiago, capetown, tokio, barrow))
names(df) <- c("lat", "lng")

leaflet(df) \%>\%
  addProviderTiles(providers$CartoDB.Positron) \%>\%
  addGeodesicPolylines(
    lng = ~lng, lat = ~lat, weight = 2, color = "red",
    steps = 50, opacity = 1
  ) \%>\%
  addCircleMarkers(df,
    lat = ~lat, lng = ~lng, radius = 3, stroke = FALSE,
    fillColor = "black", fillOpacity = 1
  )

## for more examples see
# browseURL(system.file("examples/geodesic.R", package = "leaflet.extras"))
}
