% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_sales.R
\name{lp_sales}
\alias{lp_sales}
\alias{lp_all_sales}
\alias{lp_next_url}
\alias{lp_next}
\title{Leanpub Sales Information}
\usage{
lp_sales(slug, api_key = NULL, secure = TRUE, verbose = TRUE, ...)

lp_all_sales(
  slug,
  api_key = NULL,
  secure = TRUE,
  verbose = TRUE,
  page = NULL,
  ...
)

lp_next_url(result)

lp_next(result, ...)
}
\arguments{
\item{slug}{slug of the project}

\item{api_key}{API key for Leanpub, passed to \code{\link{lp_api_key}}}

\item{secure}{passed to \code{\link{lp_base_url}} for https}

\item{verbose}{print diagnostic messages}

\item{...}{additional options to pass to \code{\link[httr]{GET}}}

\item{page}{page to extract for sales}

\item{result}{an object of class `lp_results`, which must have
a `response` slot in a list}
}
\value{
List of the result of the \code{\link[httr]{GET}} call and
the content
}
\description{
Leanpub Sales Information
}
\note{
See \url{https://leanpub.com/help/api}
}
\examples{
\dontrun{
if (lp_have_api_key()) {
res1 = lp_all_sales(slug = "biostatmethods")
nurl = lp_next_url(res1)
res_next = lp_next(res1)

}
}
}
