% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{flefko2}
\alias{flefko2}
\title{Create Function-based Ahistorical Matrix Projection Model}
\usage{
flefko2(
  year = "all",
  patch = "all",
  stageframe,
  supplement = NULL,
  repmatrix = NULL,
  overwrite = NULL,
  data = NULL,
  modelsuite = NULL,
  surv_model = NULL,
  obs_model = NULL,
  size_model = NULL,
  sizeb_model = NULL,
  sizec_model = NULL,
  repst_model = NULL,
  fec_model = NULL,
  jsurv_model = NULL,
  jobs_model = NULL,
  jsize_model = NULL,
  jsizeb_model = NULL,
  jsizec_model = NULL,
  jrepst_model = NULL,
  jmatst_model = NULL,
  paramnames = NULL,
  inda = NULL,
  indb = NULL,
  indc = NULL,
  annua = NULL,
  annub = NULL,
  annuc = NULL,
  surv_dev = 0,
  obs_dev = 0,
  size_dev = 0,
  sizeb_dev = 0,
  sizec_dev = 0,
  repst_dev = 0,
  fec_dev = 0,
  jsurv_dev = 0,
  jobs_dev = 0,
  jsize_dev = 0,
  jsizeb_dev = 0,
  jsizec_dev = 0,
  jrepst_dev = 0,
  jmatst_dev = 0,
  density = NA,
  fecmod = 1,
  random.inda = FALSE,
  random.indb = FALSE,
  random.indc = FALSE,
  negfec = FALSE,
  ipm_method = "CDF",
  reduce = FALSE,
  simple = FALSE,
  err_check = FALSE,
  exp_tol = 700,
  theta_tol = 1e+08,
  sparse_output = FALSE
)
}
\arguments{
\item{year}{A variable corresponding to the observation occasion, or a set
of such values, given in values associated with the year term used in linear 
model development. Defaults to \code{"all"}, in which case matrices will be
estimated for all occasions.}

\item{patch}{A variable designating which patches or subpopulations will have
matrices estimated. Defaults to \code{"all"}, but can also be set to specific
patch names or a vector thereof.}

\item{stageframe}{An object of class \code{stageframe}. These objects are
generated by function \code{\link{sf_create}()}, and include information on
the size, observation status, propagule status, reproduction status,
immaturity status, maturity status, stage group, size bin widths, and other
key characteristics of each ahistorical stage.}

\item{supplement}{An optional data frame of class \code{lefkoSD} that
provides supplemental data that should be incorporated into the MPM. Three
kinds of data may be integrated this way: transitions to be estimated via the
use of proxy transitions, transition overwrites from the literature or
supplemental studies, and transition multipliers for survival and fecundity.
This data frame should be produced using the \code{\link{supplemental}()}
function. Can be used in place of or in addition to an overwrite table (see 
\code{overwrite} below) and a reproduction matrix (see \code{repmatrix}
below).}

\item{repmatrix}{An optional reproduction matrix. This matrix is composed
mostly of \code{0}s, with non-zero entries acting as element identifiers and
multipliers for fecundity (with \code{1} equaling full fecundity). If left
blank, and no \code{supplement} is provided, then \code{flefko2()} will
assume that all stages marked as reproductive produce offspring at 1x that of
estimated fecundity, and that offspring production will yield the first stage
noted as propagule or immature. Must be the dimensions of an ahistorical
matrix.}

\item{overwrite}{An optional data frame developed with the
\code{\link{overwrite}()} function describing transitions to be overwritten
either with given values or with other estimated transitions. Note that this
function supplements overwrite data provided in \code{supplement}.}

\item{data}{The historical vertical demographic data frame used to estimate
vital rates (class \code{hfvdata}), which is required to initialize times and
patches properly. Variable names should correspond to the naming conventions
in \code{\link{verticalize3}()} and \code{\link{historicalize3}()}. Not
required if option \code{modelsuite} is set to a \code{vrm_input} object.}

\item{modelsuite}{One of three kinds of lists. The first is a \code{lefkoMod}
object holding the vital rate models and associated metadata. The second is
a \code{lefkoModList} object, which is a list of \code{lefkoMod} objects
generally created to conduct a bootstrapped MPM analysis. Alternatively,
an object of class \code{vrm_input} may be provided. If given, then
\code{surv_model}, \code{obs_model}, \code{size_model}, \code{sizeb_model},
\code{sizec_model}, \code{repst_model}, \code{fec_model}, \code{jsurv_model},
\code{jobs_model}, \code{jsize_model}, \code{jsizeb_model},
\code{jsizec_model}, \code{jrepst_model}, \code{jmatst_model}, and
\code{paramnames} are not required. One or more of these models should
include size or reproductive status in occasion \emph{t}-1. Although this is
optional input, it is recommended, and without it all vital rate model inputs
(named \code{XX_model}) are required.}

\item{surv_model}{A linear model predicting survival probability. This can 
be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{obs_model}{A linear model predicting sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{size_model}{A linear model predicting primary size. This can be a model
of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{sizeb_model}{A linear model predicting secondary size. This can be a
model of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{sizec_model}{A linear model predicting tertiary size. This can be a
model of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{repst_model}{A linear model predicting reproduction probability. This 
can be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{fec_model}{A linear model predicting fecundity. This can be a model of
class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl}, \code{vglm},
\code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is provided. This
model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{jsurv_model}{A linear model predicting juvenile survival probability.
This can be a model of class \code{glm} or \code{glmer}, and requires a
predicted binomial variable under a logit link. Ignored if \code{modelsuite}
is provided. This model must have been developed in a modeling exercise
testing only the impacts of occasion \emph{t}.}

\item{jobs_model}{A linear model predicting juvenile sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{jsize_model}{A linear model predicting juvenile primary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{jsizeb_model}{A linear model predicting juvenile secondary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{jsizec_model}{A linear model predicting juvenile tertiary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{jrepst_model}{A linear model predicting reproduction probability of a 
mature individual that was immature in time \emph{t}. This can be a model
of class \code{glm} or \code{glmer}, and requires a predicted binomial
variable under a logit link. Ignored if \code{modelsuite} is provided. This
model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{jmatst_model}{A linear model predicting maturity probability of an 
individual that was immature in time \emph{t}. This can be a model of class
\code{glm} or \code{glmer}, and requires a predicted binomial variable under
a logit link. Ignored if \code{modelsuite} is provided. This model must have
been developed in a modeling exercise testing only the impacts of occasion
\emph{t}.}

\item{paramnames}{A data frame with three columns, the first describing all
terms used in linear modeling, the second (must be called \code{mainparams})
giving the general model terms that will be used in matrix creation, and the
third showing the equivalent terms used in modeling (must be named
\code{modelparams}). Function \code{\link{create_pm}()} can be used to
create a skeleton \code{paramnames} object, which can then be edited. Only
required if \code{modelsuite} is not supplied.}

\item{inda}{Can be a single value to use for individual covariate \code{a}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{indb}{Can be a single value to use for individual covariate \code{b}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{indc}{Can be a single value to use for individual covariate \code{c}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{annua}{Can be a single value to use for annual covariate \code{a}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{annub}{Can be a single value to use for annual covariate \code{b}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{annuc}{Can be a single value to use for annual covariate \code{c}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{surv_dev}{A numeric value to be added to the y-intercept in the linear
model for survival probability. Defaults to \code{0}.}

\item{obs_dev}{A numeric value to be added to the y-intercept in the linear
model for observation probability. Defaults to \code{0}.}

\item{size_dev}{A numeric value to be added to the y-intercept in the linear
model for primary size. Defaults to \code{0}.}

\item{sizeb_dev}{A numeric value to be added to the y-intercept in the linear
model for secondary size. Defaults to \code{0}.}

\item{sizec_dev}{A numeric value to be added to the y-intercept in the linear
model for tertiary size. Defaults to \code{0}.}

\item{repst_dev}{A numeric value to be added to the y-intercept in the linear
model for probability of reproduction. Defaults to \code{0}.}

\item{fec_dev}{A numeric value to be added to the y-intercept in the linear
model for fecundity. Defaults to \code{0}.}

\item{jsurv_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile survival probability. Defaults to \code{0}.}

\item{jobs_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile observation probability. Defaults to \code{0}.}

\item{jsize_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile primary size. Defaults to \code{0}.}

\item{jsizeb_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile secondary size. Defaults to \code{0}.}

\item{jsizec_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile tertiary size. Defaults to \code{0}.}

\item{jrepst_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile reproduction probability. Defaults to \code{0}.}

\item{jmatst_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile maturity probability. Defaults to \code{0}.}

\item{density}{A numeric value indicating density value to use to propagate
matrices. Only needed if density is an explanatory term used in one or more
vital rate models. Defaults to \code{NA}.}

\item{fecmod}{A scalar multiplier of fecundity. Defaults to \code{1.0}.}

\item{random.inda}{A logical value denoting whether to treat individual
covariate \code{a} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random.indb}{A logical value denoting whether to treat individual
covariate \code{b} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random.indc}{A logical value denoting whether to treat individual
covariate \code{c} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{negfec}{A logical value denoting whether fecundity values estimated to
be negative should be reset to \code{0}. Defaults to \code{FALSE}.}

\item{ipm_method}{A string indicating what method to use to estimate size
transition probabilities, if size is treated as continuous. Options include:
\code{"midpoint"}, which utilizes the midpoint method; and \code{"CDF"},
which uses the cumulative distribution function. Defaults to \code{"CDF"}.}

\item{reduce}{A logical value denoting whether to remove ahistorical stages
associated solely with \code{0} transitions. These are only removed in cases
where the associated row and column sums in ALL matrices estimated equal 0. 
Defaults to \code{FALSE}.}

\item{simple}{A logical value indicating whether to produce \code{A},
\code{U}, and \code{F} matrices, or only the latter two. Defaults to
\code{FALSE}, in which case all three are output.}

\item{err_check}{A logical value indicating whether to append extra
information used in matrix calculation within the output list. Defaults to
\code{FALSE}.}

\item{exp_tol}{A numeric value used to indicate a maximum value to set
exponents to in the core kernel to prevent numerical overflow. Defaults to
\code{700}.}

\item{theta_tol}{A numeric value used to indicate a maximum value to theta as
used in the negative binomial probability density kernel. Defaults to
\code{100000000}, but can be reset to other values during error checking.}

\item{sparse_output}{A logical value indicating whether to output matrices
in sparse format. Defaults to \code{FALSE}, in which case all matrices are
output in standard matrix format.}
}
\value{
If the user inputs a standard \code{lefkoMod} or \code{vrm_input}
object in argument \code{modelsuite}, or individual vital rate models are
input separately,then this function will return an object of class
\code{lefkoMat}. If the user inputs an object of class \code{lefkoModList}
in argument \code{modelsuite}, then the output will be an object of class
\code{lefkoMatList}, in which each element is an object of class
\code{lefkoMat}.

A \code{lefkoMat} object is a list that holds one full  matrix projection
model and all of its metadata. The structure has the following elements:

\item{A}{A list of full projection matrices in order of sorted patches and
occasion times. All matrices output in R's \code{matrix} class, or in
the \code{dgCMatrix} class from the \code{Matrix} package if sparse.}
\item{U}{A list of survival transition matrices sorted as in \code{A}. All 
matrices output in R's \code{matrix} class, or in the \code{dgCMatrix} class
from the \code{Matrix} package if sparse.}
\item{F}{A list of fecundity matrices sorted as in \code{A}. All matrices 
output in R's \code{matrix} class, or in the \code{dgCMatrix} class from the
\code{Matrix} package if sparse.}
\item{hstages}{A data frame matrix showing the pairing of ahistorical stages
used to create historical stage pairs. Set to \code{NA} for ahistorical
matrices.}
\item{agestages}{A data frame showing age-stage pairs. In this function, it
is set to \code{NA}. Only used in output to function \code{aflefko2}().}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages, in the form of a modified stageframe that includes
status as an entry stage through reproduction.}
\item{labels}{A data frame giving the population, patch, and year of each
matrix in order. In \code{flefko2()}, only one population may be analyzed at
once.}
\item{dataqc}{A vector showing the numbers of individuals and rows in the
vertical dataset used as input.}
\item{matrixqc}{A short vector describing the number of non-zero elements in
\code{U} and \code{F} matrices, and the number of annual matrices.}
\item{modelqc}{This is the \code{qc} portion of the \code{modelsuite} input.}
\item{prob_out}{An optional element only added if \code{err_check = TRUE}.
This is a list of vital rate probability matrices, with 7 columns in the
order of survival, observation probability, reproduction probability, primary
size transition probability, secondary size transition probability, tertiary
size transition probability, and probability of juvenile transition to
maturity.}
\item{allstages}{An optional element only added if \code{err_check = TRUE}.
This is a data frame giving the values used to determine each matrix element
capable of being estimated.}
}
\description{
Function \code{flefko2()} returns ahistorical MPMs corresponding to the
patches and occasions given, including the associated component transition
and fecundity matrices, a data frame detailing the characteristics of the
ahistorical stages used, and a data frame characterizing the patch and
occasion combinations corresponding to these matrices.
}
\section{Notes}{

Unlike \code{\link{rlefko2}()}, \code{\link{rlefko3}()},
\code{\link{arlefko2}()}, and \code{\link{rleslie}()}, this function does not
currently distinguish populations. Users wishing to use the same vital rate
models across populations should label them as patches (though we do not
advise this approach, as populations should typically be treated as
statistically independent).

This function will yield incorrect estimates if the models utilized
incorporate state in occasion \emph{t}-1. Only use models developed testing
for ahistorical effects.

The default behavior of this function is to estimate fecundity with regards
to transitions specified via associated fecundity multipliers in the
\code{supplement}. If this field is left empty, then fecundity will be
estimated at full for all transitions leading from reproductive stages to
immature and propagule stages.

Users may at times wish to estimate MPMs using a dataset incorporating
multiple patches or subpopulations, but without discriminating between those
patches or subpopulations. Should the aim of analysis be a general MPM that
does not distinguish these patches or subpopulations, the
\code{modelsearch()} run should not include patch terms.

Input options including multiple variable names must be entered in the order
of variables in occasion \emph{t}+1 and \emph{t}. Rearranging the order will
lead to erroneous calculations, and may lead to fatal errors.

Care should be taken to match the random status of year and patch to the
states of those variables within the \code{modelsuite}. If they do not match,
then they will be treated as zeroes in vital rate estimation.

The \code{ipm_method} function gives the option of using two different means
of estimating the probability of size transition. The midpoint method
(\code{"midpoint"}) refers to the method in which the probability is
estimated by first estimating the probability associated with transition from
the exact size at the midpoint of the size class using the corresponding
probability density function, and then multiplying that value by the bin
width of the size class. Doak et al. 2021 (Ecological Monographs) noted that
this method can produce biased results, with total size transitions
associated with a specific size not totaling to 1.0 and even specific size
transition probabilities capable of being estimated at values greater than
1.0. The alternative and default method, \code{"CDF"}, uses the corresponding
cumulative density function to estimate the probability of size transition as
the cumulative probability of size transition at the greater limit of the
size class minus the cumulative probability of size transition at the lower
limit of the size class. The latter method avoids this bias. Note, however,
that both methods are exact and unbiased for negative binomial and Poisson
distributions.

Under the Gaussian and gamma size distributions, the number of estimated
parameters may differ between the two \code{ipm_method} settings. Because
the midpoint method has a tendency to incorporate upward bias in the
estimation of size transition probabilities, it is more likely to yield non-
zero values when the true probability is extremely close to 0. This will
result in the \code{summary.lefkoMat} function yielding higher numbers of
estimated parameters than the \code{ipm_method = "CDF"} yields in some cases.

Using the \code{err_check} option will produce a matrix of 7 columns, each
characterizing a different vital rate. The product of each row yields an
element in the associated \code{U} matrix. The number and order of elements
in each column of this matrix matches the associated matrix in column vector
format. Use of this option is generally for the purposes of debugging code.

Individual covariates are treated as categorical only if they are set as
random terms. Fixed categorical individual covariates are currently not
allowed. However, such terms may be supplied if the \code{modelsuite} option
is set to a \code{vrm_input} object. In that case, the user should also set
the logical random switch for the individual covariate to be used to 
\code{TRUE} (e.g., \code{random.inda = TRUE}).
}

\examples{
# Lathyrus example
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr", 
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r", 
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, 
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988", 
  nonobsacol = "Dormant1988", stageassign = lathframeln,
  stagesize = "sizea", censorcol = "Missing1988", censorkeep = NA,
  NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

lathvertln_adults <- subset(lathvertln, stage2index > 2)
surv_model <- glm(alive3 ~ sizea2 + as.factor(patchid),
  data = lathvertln_adults, family = "binomial")

obs_data <- subset(lathvertln_adults, alive3 == 1)
obs_model <- glm(obsstatus3 ~ as.factor(patchid), data = obs_data,
  family = "binomial")

size_data <- subset(obs_data, obsstatus3 == 1)
siz_model <- lm(sizea3 ~ sizea2 + repstatus2 + as.factor(patchid) + 
  as.factor(year2), data = size_data)

reps_model <- glm(repstatus3 ~ sizea2 + as.factor(patchid) + as.factor(year2),
  data = size_data, family = "binomial")

fec_data <- subset(lathvertln_adults, repstatus2 == 1)
fec_model <- glm(feca2 ~ sizea2 + as.factor(patchid) + as.factor(year2),
  data = fec_data, family = "poisson")

lathvertln_juvs <- subset(lathvertln, stage2index < 3)
jsurv_model <- glm(alive3 ~ as.factor(patchid), data = lathvertln_juvs,
  family = "binomial")

jobs_data <- subset(lathvertln_juvs, alive3 == 1)
jobs_model <- glm(obsstatus3 ~ 1, family = "binomial", data = jobs_data)

jsize_data <- subset(jobs_data, obsstatus3 == 1)
jsiz_model <- lm(sizea3 ~ as.factor(year2), data = jsize_data)

jrepst_model <- 0
jmatst_model <- 1

mod_params <- create_pm(name_terms = TRUE)
mod_params$modelparams[3] <- "patchid"
mod_params$modelparams[5] <- "obsstatus3"
mod_params$modelparams[6] <- "sizea3"
mod_params$modelparams[9] <- "repstatus3"
mod_params$modelparams[11] <- "feca2"
mod_params$modelparams[12] <- "sizea2"
mod_params$modelparams[18] <- "repstatus2"

lathsupp2 <- supplemental(stage3 = c("Sd", "Sdl", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "rep", "rep"),
  givenrate = c(0.345, 0.054, NA, NA),
  multiplier = c(NA, NA, 0.345, 0.054),
  type = c(1, 1, 3, 3), stageframe = lathframeln, historical = FALSE)

lathmat2ln <- flefko2(year = "all", patch = "all", data = lathvertln,
  stageframe = lathframeln, supplement = lathsupp2, paramnames = mod_params,
  surv_model = surv_model, obs_model = obs_model, size_model = siz_model,
  repst_model = reps_model, fec_model = fec_model, jsurv_model = jsurv_model,
  jobs_model = jobs_model, jsize_model = jsiz_model,
  jrepst_model = jrepst_model, jmatst_model = jmatst_model, reduce = FALSE)


# Cypripedium example using three size metrics for classification
data(cypdata)

sizevector_f <- c(0, 0, 0, 0, 0, 0, seq(1, 12, by = 1), seq(0, 9, by = 1),
  seq(0, 8, by = 1), seq(0, 7, by = 1), seq(0, 6, by = 1), seq(0, 5, by = 1),
  seq(0, 4, by = 1), seq(0, 3, by = 1), 0, 1, 2, 0, 1, 0, 
  0, 0, 1, 0)
sizebvector_f <- c(0, 0, 0, 0, 0, 0, rep(0, 12), rep(1, 10), rep(2, 9),
  rep(3, 8), rep(4, 7), rep(5, 6), rep(6, 5), rep(7, 4), rep(8, 3), 9, 9, 10, 
  0, 1, 1, 2)
sizecvector_f <- c(0, 0, 0, 0, 0, 0, rep(0, 12), rep(0, 10), rep(0, 9),
  rep(0, 8), rep(0, 7), rep(0, 6), rep(0, 5), rep(0, 4), 0, 0, 0, 0, 0, 0, 
  1, 1, 1, 1)
stagevector_f <- c("DS", "P1", "P2", "P3", "Sdl", "Dorm", "V1 I0 D0",
  "V2 I0 D0", "V3 I0 D0", "V4 I0 D0", "V5 I0 D0", "V6 I0 D0", "V7 I0 D0",
  "V8 I0 D0", "V9 I0 D0", "V10 I0 D0", "V11 I0 D0", "V12 I0 D0", "V0 I1 D0",
  "V1 I1 D0", "V2 I1 D0", "V3 I1 D0", "V4 I1 D0", "V5 I1 D0", "V6 I1 D0",
  "V7 I1 D0", "V8 I1 D0", "V9 I1 D0", "V0 I2 D0", "V1 I2 D0", "V2 I2 D0",
  "V3 I2 D0", "V4 I2 D0", "V5 I2 D0", "V6 I2 D0", "V7 I2 D0", "V8 I2 D0",
  "V0 I3 D0", "V1 I3 D0", "V2 I3 D0", "V3 I3 D0", "V4 I3 D0", "V5 I3 D0",
  "V6 I3 D0", "V7 I3 D0", "V0 I4 D0", "V1 I4 D0", "V2 I4 D0", "V3 I4 D0",
  "V4 I4 D0", "V5 I4 D0", "V6 I4 D0", "V0 I5 D0", "V1 I5 D0", "V2 I5 D0",
  "V3 I5 D0", "V4 I5 D0", "V5 I5 D0", "V0 I6 D0", "V1 I6 D0", "V2 I6 D0",
  "V3 I6 D0", "V4 I6 D0", "V0 I7 D0", "V1 I7 D0", "V2 I7 D0", "V3 I7 D0",
  "V0 I8 D0", "V1 I8 D0", "V2 I8 D0", "V0 I9 D0", "V1 I9 D0", "V0 I10 D0",
  "V0 I0 D1", "V0 I1 D1", "V1 I1 D1", "V0 I2 D1")
repvector_f <- c(0, 0, 0, 0, 0, rep(0, 13), rep(1, 59))
obsvector_f <- c(0, 0, 0, 0, 0, 0, rep(1, 71))
matvector_f <- c(0, 0, 0, 0, 0, rep(1, 72))
immvector_f <- c(0, 1, 1, 1, 1, rep(0, 72))
propvector_f <- c(1, rep(0, 76))
indataset_f <- c(0, 0, 0, 0, 0, rep(1, 72))
binvec_f <- c(0, 0, 0, 0, 0, rep(0.5, 72))
binbvec_f <- c(0, 0, 0, 0, 0, rep(0.5, 72))
bincvec_f <- c(0, 0, 0, 0, 0, rep(0.5, 72))

vertframe_f <- sf_create(sizes = sizevector_f, sizesb = sizebvector_f,
  sizesc = sizecvector_f, stagenames = stagevector_f, repstatus = repvector_f,
  obsstatus = obsvector_f, propstatus = propvector_f, immstatus = immvector_f,
  matstatus = matvector_f, indataset = indataset_f, binhalfwidth = binvec_f,
  binhalfwidthb = binbvec_f, binhalfwidthc = bincvec_f)

vert_data_f <- verticalize3(cypdata, noyears = 6, firstyear = 2004,
  individcol = "plantid", blocksize = 4, sizeacol = "Veg.04",
  sizebcol = "Inf.04", sizeccol = "Inf2.04", repstracol = "Inf.04",
  repstrbcol = "Inf2.04", fecacol = "Pod.04", censorcol = "censor",
  censorkeep = 1, censorRepeat = FALSE, stageassign = vertframe_f,
  stagesize = "sizeabc", NAas0 = TRUE, censor = FALSE)

surv_model <- glm(alive3 ~ sizea2 + sizeb2, data = vert_data_f,
  family = "binomial")

obs_data <- subset(vert_data_f, alive3 == 1)
obs_model <- glm(obsstatus3 ~ sizeb2 + as.factor(year2), data = obs_data,
  family = "binomial")

size_data <- subset(obs_data, obsstatus3 == 1)
siz_model <- MASS::glm.nb(sizea3 ~ sizea2 + sizeb2 + as.factor(year2),
  data = size_data)
sizb_model <- glm(sizeb3 ~ sizea2 + sizeb2 + repstatus2 + as.factor(year2),
  data = size_data, family = "poisson")
sizc_model <- glm(sizec3 ~ repstatus2, data = size_data, family = "poisson")

reps_model <- glm(repstatus3 ~ sizea2 + sizeb2 + repstatus2 + as.factor(year2),
  data = size_data, family = "binomial")

fec_data <- subset(vert_data_f, repstatus2 == 1)
fec_model <- glm(feca2 ~ sizeb2 + as.factor(year2), data = fec_data,
  family = "poisson")

mod_params <- create_pm(name_terms = TRUE)
mod_params$modelparams[3] <- "patchid"
mod_params$modelparams[4] <- "alive3"
mod_params$modelparams[5] <- "obsstatus3"
mod_params$modelparams[6] <- "sizea3"
mod_params$modelparams[9] <- "repstatus3"
mod_params$modelparams[11] <- "feca2"
mod_params$modelparams[12] <- "sizea2"
mod_params$modelparams[18] <- "repstatus2"

vertsupp2f <- supplemental(stage3 = c("DS", "P1", "P2", "P3", "Sdl", "Sdl",
    "Dorm", "V1 I0 D0", "V2 I0 D0", "V3 I0 D0", "DS", "P1"),
  stage2 = c("DS", "DS", "P1", "P2", "P3", "Sdl", "Sdl", "Sdl", "Sdl", "Sdl",
    "rep", "rep"), 
  eststage3 = c(NA, NA, NA, NA, NA, NA, "Dorm", "V1 I0 D0", "V2 I0 D0",
    "V3 I0 D0", NA, NA), 
  eststage2 = c(NA, NA, NA, NA, NA, NA, "V1 I0 D0", "V1 I0 D0", "V1 I0 D0",
    "V1 I0 D0", NA, NA), 
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, 0.40, NA, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 0.5 * 5000,
    0.5 * 5000),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3), stageframe = vertframe_f,
  historical = FALSE)

vert_mats_f2 <- flefko2(stageframe = vertframe_f, supplement = vertsupp2f,
  data = vert_data_f, surv_model = surv_model, obs_model = obs_model,
  size_model = siz_model, sizeb_model = sizb_model, sizec_model = sizc_model,
  repst_model = reps_model, fec_model = fec_model, paramnames = mod_params)

}
\seealso{
\code{\link{mpm_create}()}

\code{\link{flefko3}()}

\code{\link{aflefko2}()}

\code{\link{arlefko2}()}

\code{\link{fleslie}()}

\code{\link{rlefko3}()}

\code{\link{rlefko2}()}

\code{\link{rleslie}()}
}
