% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifiers.R
\name{KNeighborsClassifier}
\alias{KNeighborsClassifier}
\title{KNeighborsClassifier}
\value{
R6 Class of KNeighborsClassifier
}
\description{
Wrapper R6 Class of caret::knnreg function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `KNeighborsClassifier$new`
## ------------------------------------------------

knc <- KNeighborsClassifier$new()
knc <- KNeighborsClassifier$new(k = 5)

## ------------------------------------------------
## Method `KNeighborsClassifier$fit`
## ------------------------------------------------

data(iris)
split_list <- train_test_split(iris, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

knc <- KNeighborsClassifier$new()
knc$fit(X_train, y_train)

## ------------------------------------------------
## Method `KNeighborsClassifier$predict`
## ------------------------------------------------

knc <- KNeighborsClassifier$new()
knc$fit(X_train, y_train)
preds <- knc$predict(X_test)

knc <- KNeighborsClassifier$new()
preds <- knc$fit(X_train, y_train)$predict(X_test)

preds <- KNeighborsClassifier$new()$fit(X_train, y_train)$predict(X_test)
print(caret::confusionMatrix(data=factor(preds), reference = factor(y_test)))

## ------------------------------------------------
## Method `KNeighborsClassifier$get_estimator_type`
## ------------------------------------------------

knc$get_estimator_type()
}
\seealso{
\code{\link[caret:knn3]{caret::knn3()}}
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{KNeighborsClassifier}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KNeighborsClassifier-new}{\code{KNeighborsClassifier$new()}}
\item \href{#method-KNeighborsClassifier-fit}{\code{KNeighborsClassifier$fit()}}
\item \href{#method-KNeighborsClassifier-predict}{\code{KNeighborsClassifier$predict()}}
\item \href{#method-KNeighborsClassifier-get_estimator_type}{\code{KNeighborsClassifier$get_estimator_type()}}
\item \href{#method-KNeighborsClassifier-clone}{\code{KNeighborsClassifier$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_isFitted"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_isFitted'><code>less::SklearnEstimator$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsClassifier-new"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsClassifier-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of KNeighborsClassifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsClassifier$new(k = 5)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{Number of neighbors considered (defaults to 5).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{knc <- KNeighborsClassifier$new()
knc <- KNeighborsClassifier$new(k = 5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsClassifier-fit"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsClassifier-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the k-nearest neighbors regressor from the training set (X, y).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsClassifier$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes labels}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of KNeighborsClassifier
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(iris)
split_list <- train_test_split(iris, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

knc <- KNeighborsClassifier$new()
knc$fit(X_train, y_train)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsClassifier-predict"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsClassifier-predict}{}}}
\subsection{Method \code{predict()}}{
Predict regression value for X0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsClassifier$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Factor of the predict classes.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{knc <- KNeighborsClassifier$new()
knc$fit(X_train, y_train)
preds <- knc$predict(X_test)

knc <- KNeighborsClassifier$new()
preds <- knc$fit(X_train, y_train)$predict(X_test)

preds <- KNeighborsClassifier$new()$fit(X_train, y_train)$predict(X_test)
print(caret::confusionMatrix(data=factor(preds), reference = factor(y_test)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsClassifier-get_estimator_type"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsClassifier-get_estimator_type}{}}}
\subsection{Method \code{get_estimator_type()}}{
Auxiliary function returning the estimator type e.g 'regressor', 'classifier'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsClassifier$get_estimator_type()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{knc$get_estimator_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KNeighborsClassifier-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KNeighborsClassifier-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KNeighborsClassifier$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
