% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_conditional_independence.R
\name{replicate_under_ci}
\alias{replicate_under_ci}
\title{Bootstrap replication under the null hypothesis}
\usage{
replicate_under_ci(lg_object, n_rep, nodes, M = NULL, M_sim = 1500,
  M_corr = 1.5, n_corr = 1.2, extend = 0.3)
}
\arguments{
\item{lg_object}{An object of type \code{lg}, as produced by the
\code{lg_main}-function}

\item{n_rep}{The number of replicated bootstrap samples}

\item{nodes}{Either the number of equidistant nodes to generate, or a vector
of nodes supplied by the user}

\item{M}{The value for M in the accept-reject algorithm if already known}

\item{M_sim}{The number of replicates to simulate in order to find a value
for M}

\item{M_corr}{Correction factor for M, to be on the safe side}

\item{n_corr}{Correction factor for n_new, so that we mostly will generate
enough observations in the first go}

\item{extend}{How far to extend the grid beyond the extreme data points when
interpolating, in share of the range}
}
\description{
Generate bootstrap replicates under the null hypothesis that the first two
variables are conditionally independent given the rest of the variables.
}
