% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_name.R
\name{lx_check_color}
\alias{lx_check_color}
\title{check if 'LIFX' color name is valid}
\usage{
lx_check_color(color_name, token = lx_get_token())
}
\arguments{
\item{color_name}{a color string in 'LIFX' api format (can be made with \code{\link{lx_color_name}} )}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
logical TRUE if the color name is valid; FALSE if not; throws an error if the API could not be reached or another issue occurred.
}
\description{
check if 'LIFX' color name is valid
}
\details{
calls the API endpoint https://api.lifx.com/v1/color to check if the color is valid.
}
\examples{
\dontrun{
lx_check_color("INVALID_COLOR_NAME") # invalid 'LIFX' color string returns FALSE
lx_check_color("#FFFFFF") # valid 'LIFX' color string returns TRUE
lx_check_color("orange") # valid 'LIFX' color string returns TRUE
lx_check_color('brightness:1 hue:50') # valid 'LIFX' color string returns TRUE
}
}
