% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{lx_effect_morph}
\alias{lx_effect_morph}
\title{"Morph" effect}
\usage{
lx_effect_morph(
  period = 5,
  duration = 10^10,
  palette,
  power_on = TRUE,
  fast = FALSE,
  selector = "all",
  token = lx_get_token()
)
}
\arguments{
\item{period}{This controls how quickly the morph runs. It is measured in seconds. A lower number means the animation is faster}

\item{duration}{How long the animation lasts for in seconds. Not specifying a duration makes the animation "never" stop (10^100 cycles). Specifying 0 makes the animation stop. Note that there is a known bug where the tile remains in the animation once it has completed if duration is nonzero.}

\item{palette}{array of strings (7 colors across the spectrum). You can control the colors in the animation by specifying a list of color specifiers. See \code{\link{lx_color_name}}}

\item{power_on}{if TRUE (default), switch any selected device that is off to on before performing the effect.}

\item{fast}{Executes the query fast, without initial state checks and wait for no results. See \url{https://api.developer.lifx.com/docs/set-state}}

\item{selector}{'LIFX' api "selector" such as "all", "id:12345", or "location:kitchen". Can be created with \code{\link{lx_selector}} or written manually (see \url{https://api.developer.lifx.com/docs/selectors}}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
an 'httr' response object (see \code{\link[httr]{response}})
}
\description{
"Morph" effect
}
\examples{
\dontrun{
lx_effect_morph(period = 2, palette = c("red", "blue"))
}
}
