% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_to_tbl.R
\name{split_to_tbl}
\alias{split_to_tbl}
\title{Group lines of a Rmd or Qmd file by types in a tibble}
\usage{
split_to_tbl(file)
}
\arguments{
\item{file}{A Rmd or Qmd file path}
}
\value{
A tibble with 6 columns:
\itemize{
\item \code{type}: type of the part (yaml, heading, inline, block)
\item \code{label}: label of the part (if any)
\item \code{params}: parameters of the part (if any)
\item \code{text}: text of the part (if any)
\item \code{code}: code of the part (if any)
\item \code{heading}: heading of the part (if any)
\item \code{heading_level}: level of the heading (if any)
\item \code{section}: section of the Rmd file, according to headings (if any)
}
}
\description{
Group lines of a Rmd or Qmd file by types in a tibble
}
\examples{
file <- system.file(
  "dev-template-parsing.Rmd",
  package = "lightparser"
)
split_to_tbl(file)
}
