# WARNING - Generated by {fusen} from dev/flat_split_combine.Rmd: do not edit by hand

# Problem when more that 10 groups, as 10 is between 1 and 2
text_to_test <- c(
  "# Title 1",
  "Text 1",
  "## Title 2",
  "Text 2",
  "Other text",
  "# Title 3",
  "Text 3",
  "## Title 4",
  "Text 4",
  "### Title 5",
  "Text 5",
  "### Title 6",
  "Text 6"
)

test_that("long text section are correctly splitted", {
  expect_error(
    splited <- split_headers_from_text(text_to_test),
    regexp = NA
  )

  expected_splited <- list(
    `01-heading-level-1` = "# Title 1",
    `02` = "Text 1",
    `03-heading-level-2` = "## Title 2",
    `04` = c("Text 2", "Other text"),
    `05-heading-level-1` = "# Title 3",
    `06` = "Text 3",
    `07-heading-level-2` = "## Title 4",
    `08` = "Text 4",
    `09-heading-level-3` = "### Title 5",
    `10` = "Text 5",
    `11-heading-level-3` = "### Title 6",
    `12` = "Text 6"
  )

  expect_equal(splited, expected_splited)
})
