# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# worldbank_poly

library(testthat)

# Test 1: Confirm the object is a tibble and a data.frame
test_that("worldbank_poly is a tibble and a data.frame", {
  expect_s3_class(worldbank_poly, "tbl_df")
  expect_s3_class(worldbank_poly, "data.frame")
})

# Test 2: Confirm it has exactly 7 columns
test_that("worldbank_poly has 7 columns", {
  expect_equal(length(worldbank_poly), 7)
})

# Test 3: Confirm it has exactly 177 rows
test_that("worldbank_poly has 177 rows", {
  expect_equal(nrow(worldbank_poly), 177)
})

# Test 4: Confirm column names are correct
test_that("worldbank_poly has correct column names", {
  expect_named(worldbank_poly, c(
    "name", "iso_a2", "HDI", "urban_pop", "unemployment", "pop_growth", "literacy"
  ))
})

# Test 5: Confirm column types are as expected
test_that("worldbank_poly columns have correct types", {
  expect_type(worldbank_poly$name, "character")
  expect_type(worldbank_poly$iso_a2, "character")
  expect_type(worldbank_poly$HDI, "double")
  expect_type(worldbank_poly$urban_pop, "double")
  expect_type(worldbank_poly$unemployment, "double")
  expect_type(worldbank_poly$pop_growth, "double")
  expect_type(worldbank_poly$literacy, "double")
})
