% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{as_classifier}
\alias{as_classifier}
\alias{as_regressor}
\title{Indicate model type to lime}
\usage{
as_classifier(x, labels = NULL)

as_regressor(x)
}
\arguments{
\item{x}{The model object}

\item{labels}{An optional character vector giving labels for each class}
}
\value{
A model augmented with information about the model type and
(potentially) the class labels.
}
\description{
\code{lime} requires knowledge about the type of model it is dealing with, more
specifically whether the model is a regressor or a classifier. If the model
class has a \code{\link[=model_type]{model_type()}} method defined lime can figure it out on its own
but if not, you can wrap your model in either of these functions to indicate
what type of model lime is dealing with. This can also be used to overwrite
the output from \code{\link[=model_type]{model_type()}} if the implementation uses some heuristic that
doesn't work for your particular model (e.g. keras models types are found by
checking if the activation in the last layer is linear or not - this is
rather crude). In addition \code{as_classifier} can be used to overwrite the
returned class labels - this is handy if the model does not store the labels
(again, keras springs to mind).
}
