% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dnb}
\alias{dnb}
\title{Calculate Log-Probability Density for Negative Binomial Distribution}
\usage{
dnb(x, r, m)
}
\arguments{
\item{x}{A numeric value representing the number of successes, which should be
a non-negative integer.}

\item{r}{A numeric value representing the dispersion parameter of the negative
binomial distribution. A higher value indicates a distribution more tightly
concentrated around the mean.}

\item{m}{A numeric value representing the mean of the distribution.}
}
\value{
A numeric value representing the log-probability density function value
        of observing 'x' successes given the mean 'm' and dispersion 'r'.
        This return value is given on the log scale to facilitate calculations
        that involve very small probabilities.
}
\description{
This function computes the log-probability density function of the negative
binomial distribution, given the number of successes, the dispersion parameter,
and the mean of the distribution. This is useful for probabilistic models
where negative binomial assumptions are applicable, such as certain types of
count data.
}
\examples{
dnb(5, 2, 10);
}
