% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineup.R
\name{lineupRanking}
\alias{lineupRanking}
\title{helper function for creating a LineUp ranking definition as used by \code{\link{lineup}}}
\usage{
lineupRanking(columns = c("_*", "*"), sortBy = c(), groupBy = c(), ...)
}
\arguments{
\item{columns}{list of columns shown in this ranking, besides \emph{column names of the given data frame} following special columns are available}

\item{sortBy}{list of columns to sort this ranking by, grammar: \code{"<column name>[:desc]"}}

\item{groupBy}{list of columns to group this ranking by}

\item{...}{additional ranking combination definitions as lists (\code{list(type = 'min', columns = c('a', 'b'), label = NULL)}), possible types}
}
\value{
a configured lineup ranking config
}
\description{
helper function for creating a LineUp ranking definition as used by \code{\link{lineup}}
}
\section{Special columns}{


\describe{
\item{'* '}{include all data frame columns}
\item{'_* '}{add multiple support columns (_aggregate, _rank, _selection)}
\item{'_aggregate'}{add a column for collapsing groups}
\item{'_rank'}{add a column for showing the rank of the item}
\item{'_selection'}{add a column with checkboxes for selecting items}
\item{'_group'}{add a column showing the current grouping title}
\item{'$data.frame column$'}{add the specific column}
\item{'$def column$'}{add defined column given as additional parameter to this function, see below}
}
}

\section{Ranking definition types}{

\describe{
\item{weightedSum}{a weighted sum of multiple numeric columns, extras \code{list(weights = c(0.4, 0.6))}}
\item{min}{minimum of multiple numeric columns}
\item{max}{maximum of multiple numeric columns}
\item{mean}{mean of multiple numeric columns}
\item{median}{median of multiple numeric columns}
\item{nested}{group multiple columns}
\item{script}{scripted (JS code) combination of multiple numeric columns, extras \code{list(code = '...')}}
\item{impose}{color a numerical column (column) with the color of a categorical column (categoricalColumn), changed \code{list(column = 'a', categoricalColumn = 'b')}}
}
}

\examples{
lineupRanking(columns = c("*"))
lineupRanking(columns = c("*"), sortBy = c("hp"))
lineupRanking(
  columns = c("*", "sum"),
  sum = list(type = "weightedSum", columns = c("hp", "wt"), weights = c(0.7, 0.3))
)
}
