% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{zoom}
\alias{zoom}
\alias{zoomIn}
\alias{zoomOut}
\title{Zoom in/out the current visible window}
\usage{
zoomIn(id, percent = 0.5, animation = TRUE)

zoomOut(id, percent = 0.5, animation = TRUE)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{percent}{The amount to zoom in or out. Must be a number between 0 and 1.
A value of 0.5 means that after zooming out the graph2d will show 50\% more content.}

\item{animation}{Whether or not to animate the zoom.}
}
\value{
None, side-effect is Javascript call
}
\description{
Zoom in/out the current visible window
}
\examples{
\dontrun{
linevis() \%>\%
  zoomIn()

linevis() \%>\%
  zoomOut(0.3)
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    sliderInput("zoom", "Zoom by", min = 0, max = 1, value = 0.5, step = 0.1),
    checkboxInput("animate", "Animate?", TRUE),
    actionButton("zoomIn", "Zoom IN"),
    actionButton("zoomOut", "Zoom OUT")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis()
    )
    observeEvent(input$zoomIn, {
      zoomIn("graph2d", percent = input$zoom, animation = input$animate)
    })
    observeEvent(input$zoomOut, {
      zoomOut("graph2d", percent = input$zoom, animation = input$animate)
    })
  }
)
}
}
