% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-search-ipa.R
\name{searchIPA}
\alias{searchIPA}
\title{Lookup IPA symbols with phonetic features or X-SAMPA}
\usage{
searchIPA(x = NULL, search = c("feature", "xsampa"))
}
\arguments{
\item{x}{Character. A (partial) term of the features of
an IPA symbol or the (partial) X-SAMPA symbol
corresponding to an IPA symbol. Defaults to \code{NULL},
which returns all IPA symbols with corresponding features
and X-SAMPA symbols.}

\item{search}{Character. Search mode, either \code{feature}
or \code{xsampa}.}
}
\value{
A data frame with 3 rows.
}
\description{
Lookup IPA symbols with phonetic features or X-SAMPA
}
\examples{
# Check all IPA symbols
searchIPA()

# Search with feature
searchIPA("bilabial", "feature")

# Search with X-SAMPA
searchIPA("_h", "xsampa")

}
